<?php
session_start();
include 'includes/db.php';

// Proteksi Login
if (!isset($_SESSION['login']) || !isset($_SESSION['user_id'])) { 
    header("Location: login.php"); 
    exit; 
}

$user_id = $_SESSION['user_id'];
$nama_user = $_SESSION['nama'];
$today = date('Y-m-d');

// 1. AMBIL DATA ABSEN HARI INI
// Menggunakan pengecekan agar tidak error "offset null" di tanggal 5 Feb
$cek_hari_ini = mysqli_query($conn, "SELECT jam_masuk, jam_pulang, status FROM absensi WHERE user_id = '$user_id' AND tanggal = '$today'");
$absen_sekarang = mysqli_fetch_assoc($cek_hari_ini);

// Logika tampilan (Null Coalescing ?? digunakan agar jika data kosong, tampil --:--)
$tampil_masuk = $absen_sekarang['jam_masuk'] ?? '--:--';
$tampil_pulang = ($absen_sekarang['jam_pulang'] ?? null) ?: '--:--';

// Status untuk mengunci tombol secara visual
$sudah_masuk = !empty($absen_sekarang['jam_masuk']);
$sudah_pulang = !empty($absen_sekarang['jam_pulang']) && $absen_sekarang['jam_pulang'] != "00:00:00";

// 2. AMBIL RINGKASAN 30 HARI (Sinkron Database)
$q_stats = mysqli_query($conn, "SELECT 
    SUM(CASE WHEN status = 'hadir' THEN 1 ELSE 0 END) as hadir,
    SUM(CASE WHEN status = 'izin' THEN 1 ELSE 0 END) as izin,
    SUM(CASE WHEN status = 'sakit' THEN 1 ELSE 0 END) as sakit
    FROM absensi WHERE user_id = '$user_id' AND tanggal >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)");
$stats = mysqli_fetch_assoc($q_stats);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Dashboard Presensi | PTPN IV</title>
    <link rel="icon" type="image/png" href="assets/img/logo.png">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <style>
        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background-color: #f1f5f9;
        }
        /* Custom Scrollbar */
        ::-webkit-scrollbar { width: 6px; }
        ::-webkit-scrollbar-track { background: transparent; }
        ::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
        
        .glass-header {
            background: rgba(6, 78, 59, 0.95);
            backdrop-filter: blur(10px);
        }
        .anim-hover {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .anim-hover:hover {
            transform: translateY(-4px);
        }
        /* Gradient mapping for buttons */
        .btn-green { background: linear-gradient(135deg, #059669 0%, #10b981 100%); }
        .btn-orange { background: linear-gradient(135deg, #d97706 0%, #f59e0b 100%); }
        .btn-blue { background: linear-gradient(135deg, #0284c7 0%, #0ea5e9 100%); }
        .btn-indigo { background: linear-gradient(135deg, #4f46e5 0%, #6366f1 100%); }
        
        /* Camera overlay */
        video#video {
            transform: scaleX(-1);
        }
        #camera-wrapper {
            position: relative;
            background: #000;
            border-radius: 1rem;
            overflow: hidden;
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2);
        }
        #camera-overlay {
            background: linear-gradient(to top, rgba(0,0,0,0.8) 0%, transparent 40%);
        }
    </style>
</head>
<body class="pb-24 md:pb-8">

    <!-- Navbar -->
    <nav class="glass-header text-white shadow-md sticky top-0 z-40">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16 items-center">
                <div class="flex items-center gap-3">
                    <img src="assets/img/logo.png" alt="PTPN Logo" class="h-8 w-8 bg-white p-1 rounded-lg object-contain">
                    <span class="font-black italic tracking-wide">PTPN IV DIGITAL</span>
                </div>
                <!-- User Profile Desktop -->
                <div class="hidden md:flex items-center gap-4">
                    <div class="text-right">
                        <span class="block font-bold text-sm leading-none"><?= $nama_user; ?></span>
                        <span class="text-[10px] text-emerald-200 uppercase tracking-widest font-semibold"><?= $_SESSION['instansi'] ?? 'MAGANG'; ?></span>
                    </div>
                    <a href="logout.php" class="bg-white/10 hover:bg-white/20 px-4 py-2 rounded-xl text-sm font-bold transition-all border border-white/20">Logout</a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mt-6 sm:mt-8">
        
        <!-- Welcome Section -->
        <div class="flex flex-col md:flex-row md:items-end justify-between gap-4 mb-8">
            <div>
                <h1 class="text-2xl sm:text-3xl font-black text-slate-800 mb-1">Halo, <?= explode(' ', $nama_user)[0]; ?>! 👋</h1>
                <p class="text-slate-500 font-medium text-sm sm:text-base">Mulai aktivitas hari ini, jangan lupa absen ya.</p>
            </div>
            <div class="bg-white rounded-[1.5rem] p-4 px-6 shadow-sm border border-slate-100 w-full md:w-auto text-center md:text-right flex items-center justify-between md:flex-col gap-2">
                <div class="text-left w-full md:text-right md:w-auto order-2 md:order-1">
                    <p class="text-[11px] font-bold text-emerald-600 uppercase tracking-widest"><?= date('l, d F Y'); ?></p>
                </div>
                <div class="text-3xl sm:text-4xl font-black text-slate-800 tracking-tighter tabular-nums order-1 md:order-2" id="clock">
                    00:00:00
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-12 gap-6 sm:gap-8">
            
            <!-- Left Column: Status info -->
            <div class="lg:col-span-7 space-y-6">
                
                <!-- Cards Status -->
                <div class="grid grid-cols-2 gap-4 sm:gap-6">
                    <!-- Jam Masuk Card -->
                    <div class="bg-white rounded-[1.5rem] p-5 shadow-sm border border-slate-100 flex items-center gap-4 anim-hover relative overflow-hidden">
                        <div class="absolute left-0 top-0 bottom-0 w-1.5 bg-emerald-500"></div>
                        <div class="bg-emerald-50 text-emerald-500 text-3xl h-14 w-14 rounded-2xl flex items-center justify-center flex-shrink-0">
                            🌅
                        </div>
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Jam Masuk</p>
                            <h3 class="text-xl sm:text-2xl font-black text-slate-800"><?= $tampil_masuk; ?></h3>
                        </div>
                    </div>
                    
                    <!-- Jam Pulang Card -->
                    <div class="bg-white rounded-[1.5rem] p-5 shadow-sm border border-slate-100 flex items-center gap-4 anim-hover relative overflow-hidden">
                        <div class="absolute left-0 top-0 bottom-0 w-1.5 bg-amber-500"></div>
                        <div class="bg-amber-50 text-amber-500 text-3xl h-14 w-14 rounded-2xl flex items-center justify-center flex-shrink-0">
                            🌇
                        </div>
                        <div>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Jam Pulang</p>
                            <h3 class="text-xl sm:text-2xl font-black text-slate-800"><?= $tampil_pulang; ?></h3>
                        </div>
                    </div>
                </div>

                <!-- Info Alert -->
                <div class="bg-blue-50/50 rounded-[1.5rem] border border-blue-100 p-5 flex items-start gap-4">
                    <div class="bg-blue-100 text-blue-600 p-2 rounded-xl">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <div>
                        <h4 class="font-bold text-blue-900 mb-1">Panduan Presensi</h4>
                        <p class="text-sm font-medium text-blue-800/70 leading-relaxed">Pastikan Anda memberikan izin akses lokasi GPS dan kamera saat tombol absen ditekan. Wajah harus terlihat jelas saat difoto.</p>
                    </div>
                </div>

                <!-- Summary Month -->
                <div class="bg-white rounded-[1.5rem] p-6 shadow-sm border border-slate-100">
                    <h4 class="text-xs font-bold text-slate-400 uppercase tracking-widest mb-6 border-b border-slate-100 pb-4">Ringkasan Bulan Ini</h4>
                    <div class="grid grid-cols-3 divide-x divide-slate-100 text-center">
                        <div>
                            <p class="text-3xl font-black text-emerald-600"><?= $stats['hadir'] ?? 0; ?></p>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mt-1">Hadir</p>
                        </div>
                        <div>
                            <p class="text-3xl font-black text-amber-500"><?= $stats['izin'] ?? 0; ?></p>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mt-1">Izin</p>
                        </div>
                        <div>
                            <p class="text-3xl font-black text-rose-500"><?= $stats['sakit'] ?? 0; ?></p>
                            <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mt-1">Sakit</p>
                        </div>
                    </div>
                </div>

            </div>

            <!-- Right Column: Action Buttons grid -->
            <div class="lg:col-span-5 grid grid-cols-2 gap-4">
                
                <!-- Masuk -->
                <button onclick="<?= $sudah_masuk ? "Swal.fire('Info', 'Anda sudah melakukan absen masuk hari ini.', 'info')" : "openModal('masuk')" ?>" 
                        class="btn-green text-white p-6 rounded-[1.5rem] flex flex-col items-center justify-center gap-3 anim-hover shadow-lg shadow-emerald-500/20 group relative overflow-hidden <?= $sudah_masuk ? 'opacity-75 grayscale-[50%] cursor-not-allowed' : '' ?>">
                    <div class="absolute inset-0 bg-white/20 opacity-0 group-hover:opacity-100 transition-opacity"></div>
                    <div class="bg-white/20 p-4 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 9a2 2 0 012-2h.93a2 2 0 001.664-.89l.812-1.22A2 2 0 0110.07 4h3.86a2 2 0 011.664.89l.812 1.22A2 2 0 0018.07 7H19a2 2 0 012 2v9a2 2 0 01-2 2H5a2 2 0 01-2-2V9z" />
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 13a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                    </div>
                    <span class="font-bold uppercase tracking-wider text-xs sm:text-sm">Absen Masuk</span>
                </button>

                <!-- Pulang -->
                <button onclick="<?= (!$sudah_masuk || $sudah_pulang) ? "Swal.fire('Info', 'Belum saatnya pulang atau Anda sudah absen.', 'warning')" : "openModal('pulang')" ?>" 
                        class="btn-orange text-white p-6 rounded-[1.5rem] flex flex-col items-center justify-center gap-3 anim-hover shadow-lg shadow-amber-500/20 group relative overflow-hidden <?= (!$sudah_masuk || $sudah_pulang) ? 'opacity-75 grayscale-[50%] cursor-not-allowed' : '' ?>">
                    <div class="absolute inset-0 bg-white/20 opacity-0 group-hover:opacity-100 transition-opacity"></div>
                    <div class="bg-white/20 p-4 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                        </svg>
                    </div>
                    <span class="font-bold uppercase tracking-wider text-xs sm:text-sm">Absen Pulang</span>
                </button>

                <!-- Izin -->
                <button onclick="window.location.href='izin.php'" 
                        class="btn-blue text-white p-6 rounded-[1.5rem] flex flex-col items-center justify-center gap-3 anim-hover shadow-lg shadow-sky-500/20 group relative overflow-hidden">
                    <div class="absolute inset-0 bg-white/20 opacity-0 group-hover:opacity-100 transition-opacity"></div>
                    <div class="bg-white/20 p-4 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                        </svg>
                    </div>
                    <span class="font-bold uppercase tracking-wider text-xs sm:text-sm">Surat Izin</span>
                </button>

                <!-- Riwayat -->
                <button onclick="window.location.href='riwayat.php'" 
                        class="btn-indigo text-white p-6 rounded-[1.5rem] flex flex-col items-center justify-center gap-3 anim-hover shadow-lg shadow-indigo-500/20 group relative overflow-hidden">
                    <div class="absolute inset-0 bg-white/20 opacity-0 group-hover:opacity-100 transition-opacity"></div>
                    <div class="bg-white/20 p-4 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <span class="font-bold uppercase tracking-wider text-xs sm:text-sm">Cek Riwayat</span>
                </button>

            </div>
        </div>
    </div>

    <!-- Mobile Bottom Navigation -->
    <div class="md:hidden fixed bottom-0 left-0 right-0 bg-white border-t border-slate-200 flex justify-around items-center pt-2 pb-4 px-2 shadow-[0_-10px_40px_rgba(0,0,0,0.08)] z-30">
        <a href="dashboard.php" class="flex flex-col items-center p-2 text-emerald-600 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" viewBox="0 0 20 20" fill="currentColor">
                <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Utama</span>
        </a>
        <a href="riwayat.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Riwayat</span>
        </a>
        <a href="izin.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Izin</span>
        </a>
        <a href="logout.php" class="flex flex-col items-center p-2 text-rose-400 hover:text-rose-600 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Exit</span>
        </a>
    </div>

    <!-- Custom Modal -->
    <div id="modalAbsen" class="fixed inset-0 z-50 hidden items-center justify-center px-4">
        <!-- Backdrop -->
        <div class="absolute inset-0 bg-slate-900/60 backdrop-blur-sm" onclick="closeModal()"></div>
        
        <!-- Modal Content -->
        <div class="bg-white rounded-[2rem] shadow-2xl w-full max-w-md relative z-10 overflow-hidden transform scale-95 opacity-0 transition-all duration-300" id="modalContent">
            
            <div class="px-6 py-5 border-b border-slate-100 flex justify-between items-center bg-slate-50/50">
                <h3 class="font-black text-slate-800 text-lg flex items-center gap-2">📸 Foto Presensi</h3>
                <button onclick="closeModal()" class="text-slate-400 hover:text-rose-500 bg-white p-2 rounded-xl shadow-sm border border-slate-100 transition-colors">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
                    </svg>
                </button>
            </div>
            
            <div class="p-6">
                <!-- Camera Container -->
                <div id="camera-wrapper" class="aspect-square sm:aspect-video w-full mb-4">
                    <video id="video" autoplay playsinline class="w-full h-full object-cover"></video>
                    <canvas id="canvas" class="hidden"></canvas>
                    <div id="camera-overlay" class="absolute inset-x-0 bottom-0 p-3 text-center">
                        <span class="bg-black/50 text-white text-[10px] font-bold px-3 py-1 rounded-full uppercase tracking-widest backdrop-blur-md">Wajah harus jelas</span>
                    </div>
                </div>

                <!-- GPS Status -->
                <div id="location-status" class="bg-slate-100 text-slate-600 rounded-xl p-3 flexItems-center justify-center gap-2 text-xs font-bold mb-5 border border-slate-200">
                    <div class="w-4 h-4 rounded-full border-2 border-slate-400 border-t-slate-600 animate-spin"></div>
                    Mencari GPS...
                </div>

                <!-- Mood Options -->
                <div class="mb-5">
                    <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-3 text-center">Bagaimana Mood Kamu?</p>
                    <div class="flex justify-center gap-2 sm:gap-3">
                        <label class="cursor-pointer">
                            <input type="radio" name="mood" value="Senang 😄" class="peer hidden">
                            <div class="text-3xl sm:text-4xl bg-slate-50 border-2 border-slate-100 rounded-2xl w-12 h-12 sm:w-14 sm:h-14 flex flex-col items-center justify-center peer-checked:border-emerald-500 peer-checked:bg-emerald-50 transition-all hover:scale-110">😄</div>
                        </label>
                        <label class="cursor-pointer">
                            <input type="radio" name="mood" value="Biasa 😐" class="peer hidden">
                            <div class="text-3xl sm:text-4xl bg-slate-50 border-2 border-slate-100 rounded-2xl w-12 h-12 sm:w-14 sm:h-14 flex flex-col items-center justify-center peer-checked:border-amber-500 peer-checked:bg-amber-50 transition-all hover:scale-110">😐</div>
                        </label>
                        <label class="cursor-pointer">
                            <input type="radio" name="mood" value="Lelah 😴" class="peer hidden">
                            <div class="text-3xl sm:text-4xl bg-slate-50 border-2 border-slate-100 rounded-2xl w-12 h-12 sm:w-14 sm:h-14 flex flex-col items-center justify-center peer-checked:border-indigo-500 peer-checked:bg-indigo-50 transition-all hover:scale-110">😴</div>
                        </label>
                        <label class="cursor-pointer">
                            <input type="radio" name="mood" value="Sedih 😢" class="peer hidden">
                            <div class="text-3xl sm:text-4xl bg-slate-50 border-2 border-slate-100 rounded-2xl w-12 h-12 sm:w-14 sm:h-14 flex flex-col items-center justify-center peer-checked:border-blue-500 peer-checked:bg-blue-50 transition-all hover:scale-110">😢</div>
                        </label>
                        <label class="cursor-pointer">
                            <input type="radio" name="mood" value="Marah 😡" class="peer hidden">
                            <div class="text-3xl sm:text-4xl bg-slate-50 border-2 border-slate-100 rounded-2xl w-12 h-12 sm:w-14 sm:h-14 flex flex-col items-center justify-center peer-checked:border-rose-500 peer-checked:bg-rose-50 transition-all hover:scale-110">😡</div>
                        </label>
                    </div>
                </div>

                <input type="hidden" id="tipeAbsen" value="">

                <button onclick="kirimAbsen()" id="btnKirim" class="w-full bg-emerald-600 hover:bg-emerald-700 text-white font-black uppercase tracking-widest py-4 rounded-xl shadow-[0_10px_20px_-10px_rgba(16,185,129,0.5)] transition-all active:scale-[0.98] flex items-center justify-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 9a2 2 0 012-2h.93a2 2 0 001.664-.89l.812-1.22A2 2 0 0110.07 4h3.86a2 2 0 011.664.89l.812 1.22A2 2 0 0018.07 7H19a2 2 0 012 2v9a2 2 0 01-2 2H5a2 2 0 01-2-2V9z" />
                    </svg>
                    CEKREK & HADIR
                </button>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script>
        // Clock Update
        setInterval(() => {
            const date = new Date();
            const time = date.toLocaleTimeString('id-ID', { hour12: false });
            document.getElementById('clock').innerText = time.replace(/\./g, ':');
        }, 1000);

        // Vanilla Modal Logic & Camera
        const modal = document.getElementById('modalAbsen');
        const modalContent = document.getElementById('modalContent');
        const video = document.getElementById('video');
        const canvas = document.getElementById('canvas');
        const locStatus = document.getElementById('location-status');
        let streamReference = null;
        let current_location = "";

        // GPS Listener
        if (navigator.geolocation) {
            navigator.geolocation.watchPosition(pos => {
                current_location = pos.coords.latitude + "," + pos.coords.longitude;
                locStatus.className = "bg-emerald-50 text-emerald-600 rounded-xl p-3 flex items-center justify-center gap-2 text-[10px] xl:text-xs font-bold mb-5 border border-emerald-100 uppercase tracking-wide";
                locStatus.innerHTML = `<svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg> GPS Siap: ${pos.coords.latitude.toFixed(4)}, ${pos.coords.longitude.toFixed(4)}`;
            }, (err) => {
                locStatus.className = "bg-rose-50 text-rose-600 rounded-xl p-3 flex items-center justify-center gap-2 text-[10px] xl:text-xs font-bold mb-5 border border-rose-100 uppercase tracking-wide";
                locStatus.innerHTML = `<svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path></svg> GPS Gagal: ${err.message}`;
            }, {
                enableHighAccuracy: true
            });
        } else {
            locStatus.innerHTML = "Browser tidak mendukung GPS.";
        }

        function openModal(tipe) {
            document.getElementById('tipeAbsen').value = tipe;
            document.querySelectorAll('input[name="mood"]').forEach(el => el.checked = false);
            
            modal.classList.remove('hidden');
            modal.classList.add('flex');
            // Animation
            setTimeout(() => {
                modalContent.classList.remove('scale-95', 'opacity-0');
                modalContent.classList.add('scale-100', 'opacity-100');
            }, 10);

            // Open Camera
            navigator.mediaDevices.getUserMedia({ video: { facingMode: "user" } })
            .then(stream => { 
                video.srcObject = stream; 
                streamReference = stream;
            })
            .catch(err => {
                Swal.fire('Kamera Error', 'Akses kamera ditolak! Pastikan izin kamera aktif dan menggunakan koneksi HTTPS.', 'error');
                closeModal();
            });
        }

        function closeModal() {
            modalContent.classList.remove('scale-100', 'opacity-100');
            modalContent.classList.add('scale-95', 'opacity-0');
            setTimeout(() => {
                modal.classList.add('hidden');
                modal.classList.remove('flex');
                if (streamReference) {
                    streamReference.getTracks().forEach(track => track.stop());
                }
                video.srcObject = null;
            }, 300);
        }

        function kirimAbsen() {
            const tipe = document.getElementById('tipeAbsen').value;
            const moodInput = document.querySelector('input[name="mood"]:checked');

            if (!current_location) { 
                Swal.fire('GPS Belum Siap', 'Tunggu hingga lokasi GPS terkunci (warna hijau).', 'warning');
                return; 
            }
            if (!moodInput) {
                Swal.fire('Mood Belum Dipilih', 'Pilih mood kamu hari ini dulu ya! 😄', 'warning');
                return;
            }
            
            const context = canvas.getContext('2d');
            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;
            context.drawImage(video, 0, 0, canvas.width, canvas.height);
            const dataFoto = canvas.toDataURL('image/png');

            // Button Loading
            const btn = document.getElementById('btnKirim');
            const originalHTML = btn.innerHTML;
            btn.innerHTML = `<div class="w-5 h-5 rounded-full border-2 border-white border-t-white/30 animate-spin"></div> MENGIRIM...`;
            btn.disabled = true;

            fetch('proses_absen.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `image=${encodeURIComponent(dataFoto)}&location=${current_location}&tipe=${tipe}&mood=${encodeURIComponent(moodInput.value)}`
            })
            .then(res => res.text())
            .then(data => {
                if(data.trim() === "success") {
                    Swal.fire({
                        title: 'Berhasil!',
                        text: 'Absen ' + tipe + ' berhasil dicatat!',
                        icon: 'success',
                        timer: 2000,
                        showConfirmButton: false,
                        background: '#f8fafc',
                        customClass: { popup: 'rounded-3xl' }
                    }).then(() => {
                        window.location.reload();
                    });
                } else {
                    Swal.fire('Gagal', 'Error: ' + data, 'error');
                    btn.innerHTML = originalHTML;
                    btn.disabled = false;
                }
            })
            .catch(err => {
                Swal.fire('Koneksi Error', 'Terjadi kesalahan jaringan.', 'error');
                btn.innerHTML = originalHTML;
                btn.disabled = false;
            });
        }
    </script>
</body>
</html>