<?php
session_start();
include 'includes/db.php';

// Proteksi Halaman
if (!isset($_SESSION['pembimbing'])) {
    header("Location: login_pembimbing.php");
    exit;
}

// Info pembimbing yang login
$pembimbing_id = isset($_SESSION['pembimbing_id']) ? (int)$_SESSION['pembimbing_id'] : null;
$pembimbing_nama = isset($_SESSION['pembimbing_nama']) ? $_SESSION['pembimbing_nama'] : 'Pembimbing';

// 1. SET TANGGAL (Default ke Hari Ini)
$tgl_filter = isset($_GET['tgl']) ? $_GET['tgl'] : date('Y-m-d');

// Tambahan filter berdasarkan pembimbing yang login: 
// setiap pembimbing hanya melihat peserta bimbingannya sendiri.
$filter_pembimbing = '';
if (!empty($pembimbing_id)) {
    $filter_pembimbing = " AND u.pembimbing_id = " . (int)$pembimbing_id . " ";
}

// 2. QUERY UTAMA (Hanya tampilkan yang sudah absen di tanggal terpilih dan menjadi anak bimbingannya)
$sql_main = "SELECT 
    u.id, u.nama, u.instansi, u.jurusan,
    a.status, a.jam_masuk, a.mood_masuk, a.lokasi_gps, a.foto_masuk, a.file_surat_sakit
    FROM users u 
    INNER JOIN absensi a ON u.id = a.user_id 
    WHERE a.tanggal = '$tgl_filter'
    AND u.nama NOT IN ('admin', 'pembimbing') " . $filter_pembimbing . "
    ORDER BY a.jam_masuk DESC";
$query_main = mysqli_query($conn, $sql_main);

// 3. STATISTIK (Khusus Tanggal Terpilih dan anak bimbingan)
$sql_stats = "SELECT 
    SUM(CASE WHEN a.status = 'hadir' THEN 1 ELSE 0 END) as hadir,
    SUM(CASE WHEN a.status IN ('izin', 'sakit') THEN 1 ELSE 0 END) as izin
    FROM absensi a";

if (!empty($pembimbing_id)) {
    $sql_stats .= " INNER JOIN users u ON a.user_id = u.id 
        WHERE a.tanggal = '$tgl_filter' AND u.pembimbing_id = " . (int)$pembimbing_id;
} else {
    $sql_stats .= " WHERE a.tanggal = '$tgl_filter'";
}

$q_stats = mysqli_query($conn, $sql_stats);
$stats = mysqli_fetch_assoc($q_stats);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Dashboard Pembimbing | PTPN IV</title>
    <link rel="icon" type="image/png" href="assets/img/logo.png">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        body { 
            font-family: 'Plus Jakarta Sans', sans-serif; 
            background-color: #f1f5f9; 
        }
        /* Custom scrollbar */
        ::-webkit-scrollbar { width: 6px; }
        ::-webkit-scrollbar-track { background: transparent; }
        ::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
        
        .sidebar-bg {
            background: linear-gradient(180deg, #064e3b 0%, #022c22 100%);
        }
    </style>
</head>
<body class="flex pb-20 md:pb-0 h-screen overflow-hidden">

    <!-- Sidebar Desktop -->
    <aside class="w-64 sidebar-bg text-white hidden md:flex flex-col flex-shrink-0 h-full overflow-y-auto">
        <div class="p-6 flex items-center gap-4 border-b border-emerald-800/50 mb-6">
            <div class="w-12 h-12 rounded-xl bg-white flex items-center justify-center shadow-sm p-1">
                <img src="assets/img/logo.png" alt="PTPN IV" class="w-full h-full object-contain">
            </div>
            <div>
                <h6 class="font-black tracking-wider text-base mb-0 leading-tight">PTPN IV</h6>
                <p class="text-[10px] text-emerald-300 uppercase tracking-widest font-bold">Pembimbing Panel</p>
            </div>
        </div>
        
        <nav class="flex-1 px-4 space-y-2">
            <a href="dashboard_pembimbing.php" class="flex items-center gap-3 px-4 py-3 rounded-xl bg-white/20 text-white font-bold transition-all border border-white/10">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 002-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                </svg>
                Dashboard
            </a>
            <a href="data_magang.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-emerald-100/70 hover:bg-white/10 hover:text-white font-bold transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                </svg>
                Data Magang
            </a>
            <a href="laporan_magang.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-emerald-100/70 hover:bg-white/10 hover:text-white font-bold transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                </svg>
                Laporan
            </a>
            <a href="ganti_password_pembimbing.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-emerald-100/70 hover:bg-white/10 hover:text-white font-bold transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                </svg>
                Password
            </a>
        </nav>
        
        <div class="p-4 mt-auto">
            <a href="logout_pembimbing.php" class="flex items-center justify-center gap-2 w-full py-3 rounded-xl bg-rose-500/20 text-rose-300 hover:bg-rose-500 hover:text-white font-black uppercase tracking-widest text-xs transition-all border border-rose-500/30">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                </svg>
                Logout
            </a>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="flex-1 flex flex-col h-full overflow-hidden w-full bg-slate-50">
        
        <!-- Mobile Header Overlay -->
        <div class="md:hidden bg-emerald-800 text-white px-4 py-4 flex justify-between items-center shadow-md z-20">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-white rounded border border-white/20 flex items-center justify-center p-1 shadow-sm">
                    <img src="assets/img/logo.png" class="w-full h-full object-contain" alt="PTPN IV">
                </div>
                <div>
                    <h1 class="font-black text-sm tracking-widest uppercase">PTPN IV</h1>
                    <p class="text-[9px] text-emerald-200 font-bold uppercase tracking-widest">Pembimbing Panel</p>
                </div>
            </div>
            <a href="logout_pembimbing.php" class="w-8 h-8 flex items-center justify-center bg-rose-500 text-white rounded-lg shadow-sm">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                </svg>
            </a>
        </div>

        <div class="flex-1 overflow-y-auto p-4 md:p-8">
            <!-- Header Title -->
            <div class="flex flex-col xl:flex-row justify-between xl:items-end gap-6 mb-8">
                <div>
                    <h2 class="text-2xl md:text-3xl font-black text-slate-800 mb-2">Monitoring Kehadiran</h2>
                    <p class="text-sm font-medium text-slate-500 mb-1">Pantau kehadiran peserta magang bimbingan Anda.</p>
                    <p class="text-xs font-bold text-slate-400 uppercase tracking-wider">Pembimbing: <span class="text-emerald-600"><?= htmlspecialchars($pembimbing_nama); ?></span></p>
                </div>
                
                <form action="" method="GET" class="flex sm:inline-flex items-center gap-2 bg-white p-2 rounded-2xl shadow-sm border border-slate-100">
                    <input type="date" name="tgl" value="<?= $tgl_filter ?>" class="px-3 py-2 border-0 bg-slate-50 rounded-xl font-bold text-slate-600 outline-none focus:ring-2 focus:ring-emerald-500/20 w-auto flex-1">
                    <button type="submit" class="bg-emerald-600 hover:bg-emerald-700 text-white px-5 py-2 rounded-xl font-bold uppercase text-xs tracking-wider transition-colors shadow-sm">
                        Filter
                    </button>
                </form>
            </div>

            <!-- Stats Grid -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 md:gap-6 mb-8">
                <!-- Hadir -->
                <div class="bg-white p-5 md:p-6 rounded-[1.5rem] border border-slate-100 shadow-sm flex items-center justify-between group hover:-translate-y-1 transition-transform">
                    <div>
                        <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Total Hadir</p>
                        <h3 class="text-3xl font-black text-emerald-600"><?= $stats['hadir'] ?? 0 ?></h3>
                    </div>
                    <div class="w-14 h-14 bg-emerald-50 text-emerald-500 rounded-2xl flex items-center justify-center group-hover:scale-110 transition-transform">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-7 w-7" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                    </div>
                </div>
                
                <!-- Izin / Sakit -->
                <div class="bg-white p-5 md:p-6 rounded-[1.5rem] border border-slate-100 shadow-sm flex items-center justify-between group hover:-translate-y-1 transition-transform">
                    <div>
                        <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Izin / Sakit</p>
                        <h3 class="text-3xl font-black text-amber-500"><?= $stats['izin'] ?? 0 ?></h3>
                    </div>
                    <div class="w-14 h-14 bg-amber-50 text-amber-500 rounded-2xl flex items-center justify-center group-hover:scale-110 transition-transform">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-7 w-7" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Table Card -->
            <div class="bg-white border border-slate-100 shadow-sm rounded-[1.5rem] overflow-hidden">
                <div class="bg-slate-50 border-b border-slate-100 px-6 py-4">
                    <h3 class="font-bold text-slate-700 text-sm uppercase tracking-wider">Log Aktivitas: <span class="text-emerald-600"><?= date('d M Y', strtotime($tgl_filter)) ?></span></h3>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse">
                        <thead>
                            <tr class="bg-white border-b border-slate-100">
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest">Mahasiswa</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest text-center">Status</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest text-center">Mood</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest text-center">Jam Masuk</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest text-center">Lokasi</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest text-center">Bukti</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest text-right">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-50">
                            <?php if(mysqli_num_rows($query_main) > 0): ?>
                                <?php while($row = mysqli_fetch_assoc($query_main)): ?>
                                    <tr class="hover:bg-slate-50/50 transition-colors">
                                        
                                        <!-- Mahasiswa -->
                                        <td class="px-6 py-4">
                                            <div class="flex items-center gap-4">
                                                <div class="w-10 h-10 rounded-full bg-indigo-50 text-indigo-500 font-bold flex items-center justify-center text-lg shadow-inner">
                                                    <?= substr($row['nama'], 0, 1) ?>
                                                </div>
                                                <div>
                                                    <h6 class="font-bold text-slate-800 text-sm mb-0.5"><?= $row['nama'] ?></h6>
                                                    <p class="text-[10px] font-bold text-emerald-600 uppercase tracking-widest"><?= htmlspecialchars($row['instansi'] ?? 'MAGANG') ?></p>
                                                    <p class="text-[10px] text-slate-400">Jurusan: <?= htmlspecialchars(!empty($row['jurusan']) ? $row['jurusan'] : '-') ?></p>
                                                </div>
                                            </div>
                                        </td>
                                        
                                        <!-- Status -->
                                        <td class="px-6 py-4 text-center">
                                            <?php if($row['status'] == 'hadir'): ?>
                                                <span class="inline-flex px-3 py-1 bg-emerald-50 text-emerald-600 text-[10px] font-black tracking-widest uppercase rounded-full border border-emerald-100">HADIR</span>
                                            <?php elseif($row['status'] == 'telat'): ?>
                                                <span class="inline-flex px-3 py-1 bg-indigo-50 text-indigo-600 text-[10px] font-black tracking-widest uppercase rounded-full border border-indigo-100">TELAT</span>
                                            <?php elseif($row['status'] == 'izin'): ?>
                                                <span class="inline-flex px-3 py-1 bg-amber-50 text-amber-600 text-[10px] font-black tracking-widest uppercase rounded-full border border-amber-100">IZIN</span>
                                            <?php else: ?>
                                                <span class="inline-flex px-3 py-1 bg-rose-50 text-rose-600 text-[10px] font-black tracking-widest uppercase rounded-full border border-rose-100">SAKIT</span>
                                            <?php endif; ?>
                                        </td>

                                        <!-- Mood -->
                                        <td class="px-6 py-4 text-center text-xl" title="<?= htmlspecialchars($row['mood_masuk'] ?? 'Tidak ada') ?>">
                                            <?= $row['mood_masuk'] ? mb_substr($row['mood_masuk'], -1) : '😐' ?>
                                        </td>

                                        <!-- Jam Masuk -->
                                        <td class="px-6 py-4 text-center">
                                            <span class="font-black text-slate-700 bg-slate-100 px-3 py-1 rounded-lg border border-slate-200 text-sm">
                                                <?= $row['jam_masuk'] ? substr($row['jam_masuk'], 0, 5) : '--:--' ?>
                                            </span>
                                        </td>

                                        <!-- Lokasi -->
                                        <td class="px-6 py-4 text-center">
                                            <?php if($row['lokasi_gps']): ?>
                                                <a href="https://www.google.com/maps?q=<?= htmlspecialchars($row['lokasi_gps']) ?>" target="_blank" class="inline-flex items-center gap-1.5 px-3 py-1.5 bg-sky-50 text-sky-600 hover:bg-sky-100 text-[10px] font-bold uppercase tracking-widest rounded-lg transition-colors border border-sky-100">
                                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                                        <path stroke-linecap="round" stroke-linejoin="round" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    </svg>
                                                    Peta
                                                </a>
                                            <?php else: ?>
                                                <span class="text-slate-300 font-black">-</span>
                                            <?php endif; ?>
                                        </td>

                                        <!-- Bukti -->
                                        <td class="px-6 py-4 text-center">
                                            <?php 
                                                if ($row['status'] == 'hadir') {
                                                    $path = "uploads/foto_absen/" . $row['foto_masuk'];
                                                } else {
                                                    $path = "uploads/surat_sakit/" . $row['file_surat_sakit'];
                                                }
                                                if (!empty($path) && file_exists($path) && ($row['foto_masuk'] || $row['file_surat_sakit'])): 
                                            ?>
                                                <a href="<?= $path ?>" target="_blank" class="inline-block group relative">
                                                    <div class="absolute inset-0 bg-black/50 opacity-0 group-hover:opacity-100 rounded-lg flex items-center justify-center transition-opacity">
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                                        </svg>
                                                    </div>
                                                    <img src="<?= $path ?>" class="w-10 h-10 object-cover rounded-lg border border-slate-200">
                                                </a>
                                            <?php else: ?>
                                                <span class="text-slate-300 text-xs italic font-medium">Kosong</span>
                                            <?php endif; ?>
                                        </td>

                                        <!-- Aksi -->
                                        <td class="px-6 py-4 text-right">
                                            <a href="detail_riwayat.php?id=<?= $row['id'] ?>" class="inline-flex w-8 h-8 items-center justify-center bg-white border border-slate-200 rounded-lg text-slate-400 hover:text-emerald-600 shadow-sm transition-colors">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                                    <path stroke-linecap="round" stroke-linejoin="round" d="M5 12h.01M12 12h.01M19 12h.01M6 12a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0z" />
                                                </svg>
                                            </a>
                                        </td>

                                    </tr>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="7" class="px-6 py-12 text-center text-slate-400">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 mx-auto mb-3 opacity-50" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
                                        </svg>
                                        <p class="font-bold text-sm uppercase tracking-wider">Tidak ada data absensi hari ini</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            
            <div class="h-12 md:h-0"></div> <!-- Buffer space for mobile nav -->
        </div>
    </main>

    <!-- Mobile Bottom Navigation -->
    <div class="md:hidden fixed bottom-0 left-0 right-0 bg-white border-t border-slate-200 flex justify-around items-center pt-2 pb-safe px-2 shadow-[0_-10px_40px_rgba(0,0,0,0.08)] z-50">
        <a href="dashboard_pembimbing.php" class="flex flex-col items-center p-2 text-emerald-600 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M3 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Utama</span>
        </a>
        <a href="data_magang.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Peserta</span>
        </a>
        <a href="laporan_magang.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Laporan</span>
        </a>
        <a href="ganti_password_pembimbing.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Sandi</span>
        </a>
    </div>

</body>
</html>