<?php
session_start();
include 'includes/db.php';

if (!isset($_SESSION['pembimbing'])) {
    header("Location: login_pembimbing.php");
    exit;
}

// Info pembimbing yang login
$pembimbing_id = isset($_SESSION['pembimbing_id']) ? (int)$_SESSION['pembimbing_id'] : null;

// Filter: kategori (Semua / Universitas / SMK) dan pencarian
$filter_kategori = isset($_GET['kategori']) ? mysqli_real_escape_string($conn, $_GET['kategori']) : '';
$cari = isset($_GET['cari']) ? trim(mysqli_real_escape_string($conn, $_GET['cari'])) : '';

// Query seluruh data peserta magang dari database (mahasiswa/i, siswa/i + asal)
$where = "WHERE role = 'magang'";

// Batasi hanya ke peserta yang dibimbing oleh pembimbing yang sedang login
if (!empty($pembimbing_id)) {
    $where .= " AND pembimbing_id = " . (int)$pembimbing_id;
}

if ($filter_kategori === 'Universitas' || $filter_kategori === 'SMK') {
    $where .= " AND kategori = '$filter_kategori'";
}
if ($cari !== '') {
    $where .= " AND (nama LIKE '%$cari%' OR instansi LIKE '%$cari%' OR username LIKE '%$cari%' OR jurusan LIKE '%$cari%')";
}

$q_peserta = mysqli_query($conn, "SELECT id, nama, foto, username, instansi, kategori, jurusan, created_at 
    FROM users 
    $where 
    ORDER BY kategori ASC, nama ASC");

$list_peserta = [];
while ($p = mysqli_fetch_assoc($q_peserta)) {
    $uid = (int)$p['id'];
    $q_abs = mysqli_query($conn, "SELECT COUNT(*) as total FROM absensi WHERE user_id = '$uid'");
    $abs = mysqli_fetch_assoc($q_abs);
    $total_absensi = (int)($abs['total'] ?? 0);
    $list_peserta[] = [
        'id' => $p['id'],
        'nama' => $p['nama'],
        'foto' => $p['foto'],
        'username' => $p['username'],
        'instansi' => $p['instansi'] !== null && $p['instansi'] !== '' ? $p['instansi'] : '-',
        'kategori' => $p['kategori'],
        'jurusan' => isset($p['jurusan']) && $p['jurusan'] !== null && $p['jurusan'] !== '' ? $p['jurusan'] : '-',
        'created_at' => $p['created_at'],
        'total_absensi' => $total_absensi
    ];
}

// Statistik
$jumlah_total = count($list_peserta);
$q_univ = mysqli_query($conn, "SELECT COUNT(*) as n FROM users WHERE role = 'magang' AND kategori = 'Universitas' " . (!empty($pembimbing_id) ? "AND pembimbing_id = " . (int)$pembimbing_id : ""));
$q_smk = mysqli_query($conn, "SELECT COUNT(*) as n FROM users WHERE role = 'magang' AND kategori = 'SMK' " . (!empty($pembimbing_id) ? "AND pembimbing_id = " . (int)$pembimbing_id : ""));
$jumlah_universitas = (int)mysqli_fetch_assoc($q_univ)['n'];
$jumlah_smk = (int)mysqli_fetch_assoc($q_smk)['n'];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Data Magang | PTPN IV</title>
    <link rel="icon" type="image/png" href="assets/img/logo.png">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        body { 
            font-family: 'Plus Jakarta Sans', sans-serif; 
            background-color: #f1f5f9; 
        }
        /* Custom scrollbar */
        ::-webkit-scrollbar { width: 6px; }
        ::-webkit-scrollbar-track { background: transparent; }
        ::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
        
        .sidebar-bg { background: linear-gradient(180deg, #064e3b 0%, #022c22 100%); }
    </style>
</head>
<body class="flex pb-20 md:pb-0 h-screen overflow-hidden">

    <!-- Sidebar Desktop -->
    <aside class="w-64 sidebar-bg text-white hidden md:flex flex-col flex-shrink-0 h-full overflow-y-auto">
        <div class="p-6 flex items-center gap-4 border-b border-emerald-800/50 mb-6">
            <div class="w-12 h-12 rounded-xl bg-white flex items-center justify-center shadow-sm p-1">
                <img src="assets/img/logo.png" alt="PTPN IV" class="w-full h-full object-contain">
            </div>
            <div>
                <h6 class="font-black tracking-wider text-base mb-0 leading-tight">PTPN IV</h6>
                <p class="text-[10px] text-emerald-300 uppercase tracking-widest font-bold">Pembimbing Panel</p>
            </div>
        </div>
        
        <nav class="flex-1 px-4 space-y-2">
            <a href="dashboard_pembimbing.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-emerald-100/70 hover:bg-white/10 hover:text-white font-bold transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 002-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                </svg>
                Dashboard
            </a>
            <a href="data_magang.php" class="flex items-center gap-3 px-4 py-3 rounded-xl bg-white/20 text-white font-bold transition-all border border-white/10">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                </svg>
                Data Magang
            </a>
            <a href="laporan_magang.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-emerald-100/70 hover:bg-white/10 hover:text-white font-bold transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                </svg>
                Laporan
            </a>
            <a href="ganti_password_pembimbing.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-emerald-100/70 hover:bg-white/10 hover:text-white font-bold transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                </svg>
                Password
            </a>
        </nav>
        
        <div class="p-4 mt-auto">
            <a href="logout_pembimbing.php" class="flex items-center justify-center gap-2 w-full py-3 rounded-xl bg-rose-500/20 text-rose-300 hover:bg-rose-500 hover:text-white font-black uppercase tracking-widest text-xs transition-all border border-rose-500/30">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                </svg>
                Logout
            </a>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="flex-1 flex flex-col h-full overflow-hidden w-full bg-slate-50">
        
        <!-- Mobile Header -->
        <div class="md:hidden bg-emerald-800 text-white px-4 py-4 flex justify-between items-center shadow-md z-20">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-white rounded border border-white/20 flex items-center justify-center p-1 shadow-sm">
                    <img src="assets/img/logo.png" class="w-full h-full object-contain" alt="PTPN IV">
                </div>
                <div>
                    <h1 class="font-black text-sm tracking-widest uppercase">PTPN IV</h1>
                    <p class="text-[9px] text-emerald-200 font-bold uppercase tracking-widest">Pembimbing Panel</p>
                </div>
            </div>
            <a href="logout_pembimbing.php" class="w-8 h-8 flex items-center justify-center bg-rose-500 text-white rounded-lg shadow-sm">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                </svg>
            </a>
        </div>

        <div class="flex-1 overflow-y-auto p-4 md:p-8">
            <!-- Header Title -->
            <div class="mb-8">
                <h2 class="text-2xl md:text-3xl font-black text-slate-800 mb-2">Data Magang</h2>
                <p class="text-sm font-medium text-slate-500 mb-1">Keseluruhan data mahasiswa/i dan siswa/i peserta magang.</p>
            </div>

            <!-- Filter & Search Card -->
            <div class="bg-white rounded-[1.5rem] p-5 md:p-6 shadow-sm border border-slate-100 mb-8">
                <h6 class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-4">Filter & Pencarian</h6>
                <form method="GET" class="flex flex-col md:flex-row gap-4 items-end">
                    <div class="w-full md:w-48">
                        <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2 pl-1">Kategori</label>
                        <select name="kategori" class="w-full px-4 py-2.5 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all appearance-none cursor-pointer">
                            <option value="">Semua</option>
                            <option value="Universitas" <?= $filter_kategori === 'Universitas' ? 'selected' : '' ?>>Universitas</option>
                            <option value="SMK" <?= $filter_kategori === 'SMK' ? 'selected' : '' ?>>SMK</option>
                        </select>
                    </div>
                    <div class="w-full flex-1">
                        <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2 pl-1">Cari Nama / Instansi</label>
                        <input type="text" name="cari" value="<?= htmlspecialchars($cari) ?>" placeholder="Nama, username, atau asal..." class="w-full px-4 py-2.5 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all">
                    </div>
                    <div class="w-full md:w-auto flex gap-2">
                        <button type="submit" class="flex-1 md:flex-none bg-emerald-600 hover:bg-emerald-700 text-white px-6 py-2.5 rounded-xl font-bold uppercase text-xs tracking-wider transition-colors shadow-sm flex items-center justify-center gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                            </svg>
                            Terapkan
                        </button>
                        <a href="data_magang.php" class="bg-slate-100 hover:bg-slate-200 text-slate-600 px-4 py-2.5 rounded-xl font-bold uppercase text-xs tracking-wider transition-colors shadow-sm flex items-center justify-center">
                            Reset
                        </a>
                    </div>
                </form>
            </div>

            <!-- Stats Grid -->
            <div class="grid grid-cols-2 md:grid-cols-3 gap-4 md:gap-6 mb-8">
                <!-- Total Peserta -->
                <div class="bg-white p-5 rounded-[1.5rem] border border-slate-100 shadow-sm flex flex-col justify-between group hover:-translate-y-1 transition-transform">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-10 h-10 md:w-12 md:h-12 bg-indigo-50 text-indigo-500 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 md:h-6 md:w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                            </svg>
                        </div>
                        <h3 class="text-2xl md:text-3xl font-black text-slate-800"><?= $jumlah_total ?></h3>
                    </div>
                    <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">Total Peserta</p>
                </div>
                <!-- Universitas -->
                <div class="bg-white p-5 rounded-[1.5rem] border border-slate-100 shadow-sm flex flex-col justify-between group hover:-translate-y-1 transition-transform">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-10 h-10 md:w-12 md:h-12 bg-sky-50 text-sky-500 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 md:h-6 md:w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                            </svg>
                        </div>
                        <h3 class="text-2xl md:text-3xl font-black text-sky-500"><?= $jumlah_universitas ?></h3>
                    </div>
                    <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">Universitas</p>
                </div>
                <!-- SMK -->
                <div class="col-span-2 md:col-span-1 bg-white p-5 rounded-[1.5rem] border border-slate-100 shadow-sm flex flex-col justify-between group hover:-translate-y-1 transition-transform">
                    <div class="flex items-center justify-between mb-4">
                        <div class="w-10 h-10 md:w-12 md:h-12 bg-amber-50 text-amber-500 rounded-xl flex items-center justify-center group-hover:scale-110 transition-transform">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 md:h-6 md:w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path d="M12 14l9-5-9-5-9 5 9 5z" />
                                <path d="M12 14l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 14l9-5-9-5-9 5 9 5zm0 0l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14zm-4 6v-7.5l4-2.222" />
                            </svg>
                        </div>
                        <h3 class="text-2xl md:text-3xl font-black text-amber-500"><?= $jumlah_smk ?></h3>
                    </div>
                    <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest">SMK</p>
                </div>
            </div>

            <!-- Table Card -->
            <div class="bg-white border border-slate-100 shadow-sm rounded-[1.5rem] overflow-hidden">
                <div class="bg-slate-50 border-b border-slate-100 px-6 py-4 flex justify-between items-center flex-wrap gap-2">
                    <h3 class="font-bold text-slate-700 text-sm uppercase tracking-wider">Daftar Peserta Magang</h3>
                    <span class="bg-emerald-100 text-emerald-700 text-xs font-black uppercase tracking-widest px-3 py-1.5 rounded-lg"><?= count($list_peserta) ?> Peserta</span>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="w-full text-left border-collapse min-w-[800px]">
                        <thead>
                            <tr class="bg-white border-b border-slate-100">
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest">No</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest">Peserta</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest">Username</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest text-center">Kategori</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest">Pendidikan</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest text-center">Kehadiran</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest text-right">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-50">
                            <?php if (count($list_peserta) > 0): ?>
                                <?php foreach ($list_peserta as $i => $row): ?>
                                    <tr class="hover:bg-slate-50/50 transition-colors">
                                        <td class="px-6 py-4 text-xs font-bold text-slate-400"><?= $i + 1 ?></td>
                                        
                                        <td class="px-6 py-4">
                                            <div class="flex items-center gap-3">
                                                <div class="w-10 h-10 rounded-xl overflow-hidden shadow-inner border border-slate-100 flex-shrink-0 bg-emerald-50 text-emerald-600 flex items-center justify-center font-bold">
                                                    <?php if (!empty($row['foto']) && file_exists('uploads/' . $row['foto'])): ?>
                                                        <img src="uploads/<?= htmlspecialchars($row['foto']) ?>" class="w-full h-full object-cover">
                                                    <?php else: ?>
                                                        <?= strtoupper(substr($row['nama'], 0, 1)) ?>
                                                    <?php endif; ?>
                                                </div>
                                                <div>
                                                    <h6 class="font-bold text-slate-800 text-sm mb-0.5 truncate max-w-[150px]"><?= htmlspecialchars($row['nama']) ?></h6>
                                                    <p class="text-[10px] font-bold text-slate-400">ID #<?= $row['id'] ?></p>
                                                </div>
                                            </div>
                                        </td>
                                        
                                        <td class="px-6 py-4 text-xs font-semibold text-slate-600">
                                            <?= htmlspecialchars($row['username']) ?>
                                        </td>
                                        
                                        <td class="px-6 py-4 text-center">
                                            <?php if ($row['kategori'] === 'Universitas'): ?>
                                                <span class="inline-flex px-3 py-1 bg-sky-50 text-sky-600 text-[10px] font-black tracking-widest uppercase rounded-full border border-sky-100">UNIV</span>
                                            <?php else: ?>
                                                <span class="inline-flex px-3 py-1 bg-amber-50 text-amber-600 text-[10px] font-black tracking-widest uppercase rounded-full border border-amber-100">SMK</span>
                                            <?php endif; ?>
                                        </td>
                                        
                                        <td class="px-6 py-4">
                                            <p class="text-[10px] font-bold text-slate-800 uppercase tracking-wider truncate max-w-[150px]"><?= htmlspecialchars($row['instansi']) ?></p>
                                            <p class="text-[10px] text-slate-500 truncate max-w-[150px]"><?= htmlspecialchars($row['jurusan']) ?></p>
                                        </td>
                                        
                                        <td class="px-6 py-4 text-center">
                                            <span class="inline-flex items-center gap-1.5 px-3 py-1 bg-emerald-50 text-emerald-600 text-[11px] font-black rounded-lg border border-emerald-100">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                                    <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                </svg>
                                                <?= $row['total_absensi'] ?>x
                                            </span>
                                        </td>
                                        
                                        <td class="px-6 py-4 text-right">
                                            <a href="detail_riwayat.php?id=<?= $row['id'] ?>" class="inline-flex items-center gap-2 px-3 py-1.5 bg-white border border-slate-200 hover:border-emerald-300 hover:bg-emerald-50 hover:text-emerald-700 rounded-lg text-slate-500 text-xs font-bold transition-colors shadow-sm">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                                </svg>
                                                Detail
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="7" class="px-6 py-12 text-center text-slate-400">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 mx-auto mb-3 opacity-50 text-slate-300" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                                        </svg>
                                        <p class="font-bold text-sm uppercase tracking-wider">Tidak ada data ditemukan</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            
            <div class="h-12 md:h-0"></div> <!-- Buffer space for mobile nav -->
        </div>
    </main>

    <!-- Mobile Bottom Navigation -->
    <div class="md:hidden fixed bottom-0 left-0 right-0 bg-white border-t border-slate-200 flex justify-around items-center pt-2 pb-safe px-2 shadow-[0_-10px_40px_rgba(0,0,0,0.08)] z-50">
        <a href="dashboard_pembimbing.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Utama</span>
        </a>
        <a href="data_magang.php" class="flex flex-col items-center p-2 text-emerald-600 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" viewBox="0 0 20 20" fill="currentColor">
                <path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Peserta</span>
        </a>
        <a href="laporan_magang.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Laporan</span>
        </a>
        <a href="ganti_password_pembimbing.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Sandi</span>
        </a>
    </div>

</body>
</html>
