<?php
session_start();
include 'includes/db.php';

if (!isset($_SESSION['pembimbing'])) {
    header("Location: login_pembimbing.php");
    exit;
}

$pembimbing_id   = isset($_SESSION['pembimbing_id']) ? (int)$_SESSION['pembimbing_id'] : 0;
$pembimbing_nama = isset($_SESSION['pembimbing_nama']) ? $_SESSION['pembimbing_nama'] : 'Pembimbing';

if ($pembimbing_id <= 0) {
    $error = "Akun admin umum tidak bisa mengganti sandi di halaman ini.";
} else {
    // Ambil data pembimbing
    $q = mysqli_query($conn, "SELECT password FROM pembimbing WHERE id = $pembimbing_id LIMIT 1");
    if ($q && mysqli_num_rows($q) === 1) {
        $pembimbing = mysqli_fetch_assoc($q);
    } else {
        $error = "Data pembimbing tidak ditemukan.";
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && empty($error)) {
    $lama  = $_POST['password_lama'] ?? '';
    $baru1 = $_POST['password_baru'] ?? '';
    $baru2 = $_POST['password_baru_konfirmasi'] ?? '';

    if ($lama === '' || $baru1 === '' || $baru2 === '') {
        $error = "Semua kolom wajib diisi.";
    } elseif ($baru1 !== $baru2) {
        $error = "Konfirmasi sandi baru tidak sama.";
    } elseif (strlen($baru1) < 6) {
        $error = "Sandi baru minimal 6 karakter.";
    } elseif (!password_verify($lama, $pembimbing['password'])) {
        $error = "Sandi lama salah.";
    } else {
        $hash_baru = password_hash($baru1, PASSWORD_DEFAULT);
        if (mysqli_query($conn, "UPDATE pembimbing SET password = '$hash_baru' WHERE id = $pembimbing_id")) {
            $success = "Sandi berhasil diganti.";
        } else {
            $error = "Gagal mengupdate sandi: " . mysqli_error($conn);
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Ganti Password Pembimbing | PTPN IV</title>
    <link rel="icon" type="image/png" href="assets/img/logo.png">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        body { 
            font-family: 'Plus Jakarta Sans', sans-serif; 
            background-color: #f1f5f9; 
        }
        /* Custom scrollbar */
        ::-webkit-scrollbar { width: 6px; }
        ::-webkit-scrollbar-track { background: transparent; }
        ::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
        
        .sidebar-bg { background: linear-gradient(180deg, #064e3b 0%, #022c22 100%); }
    </style>
</head>
<body class="flex pb-20 md:pb-0 h-screen overflow-hidden">

    <!-- Sidebar Desktop -->
    <aside class="w-64 sidebar-bg text-white hidden md:flex flex-col flex-shrink-0 h-full overflow-y-auto w-full max-w-[16rem]">
        <div class="p-6 flex items-center gap-4 border-b border-emerald-800/50 mb-6">
            <div class="w-12 h-12 rounded-xl bg-white flex items-center justify-center shadow-sm p-1">
                <img src="assets/img/logo.png" alt="PTPN IV" class="w-full h-full object-contain">
            </div>
            <div>
                <h6 class="font-black tracking-wider text-base mb-0 leading-tight">PTPN IV</h6>
                <p class="text-[10px] text-emerald-300 uppercase tracking-widest font-bold">Pembimbing Panel</p>
            </div>
        </div>
        
        <nav class="flex-1 px-4 space-y-2">
            <a href="dashboard_pembimbing.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-emerald-100/70 hover:bg-white/10 hover:text-white font-bold transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 002-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                </svg>
                Dashboard
            </a>
            <a href="data_magang.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-emerald-100/70 hover:bg-white/10 hover:text-white font-bold transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                </svg>
                Data Magang
            </a>
            <a href="laporan_magang.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-emerald-100/70 hover:bg-white/10 hover:text-white font-bold transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                </svg>
                Laporan
            </a>
            <a href="ganti_password_pembimbing.php" class="flex items-center gap-3 px-4 py-3 rounded-xl bg-white/20 text-white font-bold transition-all border border-white/10">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                </svg>
                Password
            </a>
        </nav>
        
        <div class="p-4 mt-auto">
            <a href="logout_pembimbing.php" class="flex items-center justify-center gap-2 w-full py-3 rounded-xl bg-rose-500/20 text-rose-300 hover:bg-rose-500 hover:text-white font-black uppercase tracking-widest text-xs transition-all border border-rose-500/30">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                </svg>
                Logout
            </a>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="flex-1 flex flex-col h-full overflow-y-auto w-full bg-slate-50">
        
        <!-- Mobile Header -->
        <div class="md:hidden bg-emerald-800 text-white px-4 py-4 flex justify-between items-center shadow-md z-20">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-white rounded border border-white/20 flex items-center justify-center p-1 shadow-sm">
                    <img src="assets/img/logo.png" class="w-full h-full object-contain" alt="PTPN IV">
                </div>
                <div>
                    <h1 class="font-black text-sm tracking-widest uppercase">PTPN IV</h1>
                    <p class="text-[9px] text-emerald-200 font-bold uppercase tracking-widest">Pembimbing Panel</p>
                </div>
            </div>
            <a href="logout_pembimbing.php" class="w-8 h-8 flex items-center justify-center bg-rose-500 text-white rounded-lg shadow-sm">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                </svg>
            </a>
        </div>

        <div class="p-4 md:p-8 flex-1 flex flex-col items-center">
            
            <div class="w-full max-w-2xl px-2">
                <!-- Header Title -->
                <div class="mb-8">
                    <h2 class="text-2xl md:text-3xl font-black text-slate-800 mb-2">Ganti Password</h2>
                    <p class="text-sm font-medium text-slate-500 mb-1">Ubah kata sandi untuk keamanan akun Anda yang lebih baik.</p>
                </div>

                <!-- Alert Messages -->
                <?php if (!empty($error)): ?>
                    <div class="bg-rose-50 border-l-4 border-l-rose-500 rounded-lg p-4 mb-6 flex items-start gap-3 shadow-sm">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-rose-500 flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <p class="text-xs font-bold text-rose-800 m-0 leading-relaxed"><?= htmlspecialchars($error) ?></p>
                    </div>
                <?php endif; ?>

                <?php if (!empty($success)): ?>
                    <div class="bg-emerald-50 border-l-4 border-l-emerald-500 rounded-lg p-4 mb-6 flex items-start gap-3 shadow-sm">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-emerald-500 flex-shrink-0 mt-0.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <p class="text-xs font-bold text-emerald-800 m-0 leading-relaxed"><?= htmlspecialchars($success) ?></p>
                    </div>
                <?php endif; ?>

                <!-- Form Card -->
                <div class="bg-white rounded-[1.5rem] p-6 shadow-sm border border-slate-100">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 bg-slate-100 text-slate-400 rounded-full flex items-center justify-center border border-slate-200 shadow-inner">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                            </svg>
                        </div>
                        <div>
                            <h6 class="text-[10px] font-bold text-slate-400 uppercase tracking-widest leading-tight">MENGGANTI SANDI UNTUK</h6>
                            <p class="text-sm font-black text-slate-700 mt-1"><?= htmlspecialchars($pembimbing_nama) ?></p>
                        </div>
                    </div>

                    <form method="POST" class="space-y-5">
                        <div class="space-y-2">
                            <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider pl-1">Sandi Lama</label>
                            <input type="password" name="password_lama" required 
                                class="w-full px-4 py-3 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all placeholder:font-medium placeholder:text-slate-400" placeholder="Masukkan kata sandi lama">
                        </div>
                        
                        <div class="space-y-2">
                            <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider pl-1">Sandi Baru</label>
                            <input type="password" name="password_baru" required 
                                class="w-full px-4 py-3 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all placeholder:font-medium placeholder:text-slate-400" placeholder="Minimal 6 karakter">
                        </div>
                        
                        <div class="space-y-2">
                            <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider pl-1">Ulangi Sandi Baru</label>
                            <input type="password" name="password_baru_konfirmasi" required 
                                class="w-full px-4 py-3 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all placeholder:font-medium placeholder:text-slate-400" placeholder="Konfirmasi sandi baru">
                        </div>
                        
                        <div class="pt-4">
                            <button type="submit" class="w-full bg-emerald-600 hover:bg-emerald-700 text-white px-6 py-3.5 rounded-xl font-black uppercase text-xs tracking-wider transition-colors shadow-sm flex items-center justify-center gap-2">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
                                </svg>
                                Simpan Perubahan Sandi
                            </button>
                        </div>
                    </form>
                </div>
                
                <div class="mt-8 text-muted small text-center opacity-50 space-y-1">
                    <p class="mb-0 text-xs font-semibold text-slate-500">Sistem Monitoring PTPN IV</p>
                    <p class="mb-0 text-[10px] font-bold text-slate-400 uppercase tracking-widest">Pengaturan Akun</p>
                </div>
            </div>
            
            <div class="h-16 md:h-0"></div> <!-- Buffer space for mobile nav -->
        </div>
    </main>

    <!-- Mobile Bottom Navigation -->
    <div class="md:hidden fixed bottom-0 left-0 right-0 bg-white border-t border-slate-200 flex justify-around items-center pt-2 pb-safe px-2 shadow-[0_-10px_40px_rgba(0,0,0,0.08)] z-50">
        <a href="dashboard_pembimbing.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Utama</span>
        </a>
        <a href="data_magang.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Peserta</span>
        </a>
        <a href="laporan_magang.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Laporan</span>
        </a>
        <a href="ganti_password_pembimbing.php" class="flex flex-col items-center p-2 text-emerald-600 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Sandi</span>
        </a>
    </div>

</body>
</html>
