<?php
session_start();

// Jika sudah login sebagai peserta magang, langsung ke dashboard
if (isset($_SESSION['login']) && $_SESSION['login'] === true) {
    header("Location: dashboard.php");
    exit;
}
// Jika sudah login sebagai pembimbing, langsung ke dashboard pembimbing
if (isset($_SESSION['pembimbing_login']) && $_SESSION['pembimbing_login'] === true) {
    header("Location: dashboard_pembimbing.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>E-Presensi Magang | PTPN IV Regional 1</title>
    <meta name="description" content="Sistem E-Presensi Magang PTPN IV Regional 1 — Pantau kehadiran dan aktivitas magang secara digital.">
    <link rel="icon" type="image/png" href="assets/img/logo.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        * { font-family: 'Plus Jakarta Sans', sans-serif; }

        body {
            background: linear-gradient(135deg, #064e3b 0%, #065f46 40%, #10b981 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }

        /* Floating background circles */
        .bg-blob {
            position: absolute;
            border-radius: 50%;
            filter: blur(60px);
            opacity: 0.25;
            pointer-events: none;
        }
        .blob-1 {
            width: 500px; height: 500px;
            background: radial-gradient(circle, #34d399, transparent);
            top: -150px; left: -150px;
            animation: floatBlob 8s ease-in-out infinite alternate;
        }
        .blob-2 {
            width: 400px; height: 400px;
            background: radial-gradient(circle, #6ee7b7, transparent);
            bottom: -100px; right: -100px;
            animation: floatBlob 10s ease-in-out infinite alternate-reverse;
        }
        .blob-3 {
            width: 300px; height: 300px;
            background: radial-gradient(circle, #a7f3d0, transparent);
            top: 50%; left: 50%;
            transform: translate(-50%, -50%);
            animation: floatBlob 12s ease-in-out infinite alternate;
        }
        @keyframes floatBlob {
            0% { transform: scale(1) translate(0, 0); }
            100% { transform: scale(1.15) translate(20px, -20px); }
        }

        /* Card */
        .glass-card {
            background: rgba(255, 255, 255, 0.97);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.5);
            box-shadow: 0 30px 60px -10px rgba(0, 0, 0, 0.3), 0 0 0 1px rgba(255,255,255,0.1);
        }

        /* Login cards */
        .login-card {
            transition: all 0.3s cubic-bezier(0.34, 1.56, 0.64, 1);
            cursor: pointer;
            position: relative;
            overflow: hidden;
        }
        .login-card::before {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, rgba(16, 185, 129, 0.05), rgba(6, 78, 59, 0.05));
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        .login-card:hover::before { opacity: 1; }
        .login-card:hover {
            transform: translateY(-6px) scale(1.02);
            box-shadow: 0 20px 40px -8px rgba(16, 185, 129, 0.3);
            border-color: #10b981;
        }
        .login-card:active {
            transform: scale(0.97);
        }

        /* Icon wrapper */
        .icon-wrap {
            width: 72px; height: 72px;
            border-radius: 1.2rem;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.25rem;
            transition: transform 0.3s ease;
        }
        .login-card:hover .icon-wrap {
            transform: rotate(-6deg) scale(1.1);
        }

        /* Sidebar image */
        .hero-sidebar {
            background: url('https://images.unsplash.com/photo-1542601906990-b4d3fb778b09?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80') no-repeat center center;
            background-size: cover;
            position: relative;
        }
        .hero-sidebar::after {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(to bottom, rgba(6, 78, 59, 0.3), rgba(6, 78, 59, 0.88));
        }

        /* Divider */
        .divider {
            position: relative;
        }
        .divider::before {
            content: '';
            position: absolute;
            top: 50%; left: 0; right: 0;
            height: 1px;
            background: #e2e8f0;
            transform: translateY(-50%);
        }
        .divider span {
            position: relative;
            background: white;
            padding: 0 1rem;
            color: #94a3b8;
            font-size: 0.75rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.1em;
        }

        /* Pulse dot */
        .pulse-dot {
            width: 10px; height: 10px;
            border-radius: 50%;
            background: #10b981;
            display: inline-block;
            animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
        }
        @keyframes pulse {
            0%, 100% { opacity: 1; box-shadow: 0 0 0 0 rgba(16,185,129,0.5); }
            50% { opacity: 0.8; box-shadow: 0 0 0 6px rgba(16,185,129,0); }
        }

        /* Particle dots */
        .particle { position: absolute; border-radius: 50%; pointer-events: none; }
    </style>
</head>
<body class="p-4 sm:p-8">

    <!-- Background blobs -->
    <div class="bg-blob blob-1"></div>
    <div class="bg-blob blob-2"></div>
    <div class="bg-blob blob-3"></div>

    <div class="w-full max-w-5xl mx-auto glass-card rounded-[2rem] sm:rounded-[3rem] overflow-hidden flex flex-col md:flex-row" style="position:relative;z-index:10;">

        <!-- ===================== SIDEBAR KIRI ===================== -->
        <div class="hidden md:flex md:w-5/12 lg:w-1/2 hero-sidebar relative items-center justify-center p-12 text-center text-white">
            <div class="relative z-10 w-full">

                <!-- Logo -->
                <div class="mx-auto w-24 h-24 bg-white rounded-[2rem] p-3 mb-8 shadow-xl border border-white/80 transform rotate-3" style="display:flex;align-items:center;justify-content:center;">
                    <img src="assets/img/logo.png" alt="PTPN Logo" class="w-full h-full object-contain" style="transform:rotate(-3deg);">
                </div>

                <h1 class="text-4xl font-black mb-3 leading-tight tracking-tight">
                    E-Presensi<br><span class="text-emerald-300">Magang</span>
                </h1>
                <p class="text-emerald-100 font-medium text-sm opacity-90 leading-relaxed max-w-xs mx-auto mb-10">
                    Sistem cerdas pemantauan kehadiran dan aktivitas magang PTPN IV Regional 1.
                </p>

                <!-- Status badge -->
                <div class="inline-flex items-center gap-2 bg-white/10 backdrop-blur-sm border border-white/20 rounded-full px-4 py-2">
                    <span class="pulse-dot"></span>
                    <span class="text-white text-xs font-bold tracking-wide">SISTEM AKTIF</span>
                </div>

                <!-- Stats -->
                <div class="mt-10 grid grid-cols-2 gap-3">
                    <div class="bg-white/10 backdrop-blur-sm border border-white/15 rounded-2xl p-4">
                        <div class="text-2xl font-black text-white mb-1">🎓</div>
                        <div class="text-white/90 text-xs font-bold uppercase tracking-wider">Peserta Magang</div>
                    </div>
                    <div class="bg-white/10 backdrop-blur-sm border border-white/15 rounded-2xl p-4">
                        <div class="text-2xl font-black text-white mb-1">👔</div>
                        <div class="text-white/90 text-xs font-bold uppercase tracking-wider">Pembimbing</div>
                    </div>
                </div>

                <!-- Dots -->
                <div class="absolute bottom-8 left-8 flex gap-2">
                    <div class="w-2 h-2 rounded-full bg-white opacity-100"></div>
                    <div class="w-2 h-2 rounded-full bg-white opacity-40"></div>
                    <div class="w-2 h-2 rounded-full bg-white opacity-40"></div>
                </div>
            </div>
        </div>

        <!-- ===================== KONTEN KANAN ===================== -->
        <div class="w-full md:w-7/12 lg:w-1/2 p-8 sm:p-12 flex flex-col justify-center bg-white">

            <!-- Mobile Header -->
            <div class="md:hidden text-center mb-8">
                <div class="inline-flex items-center justify-center w-20 h-20 bg-white rounded-[1.5rem] shadow-sm mb-4 p-2 border border-emerald-100">
                    <img src="assets/img/logo.png" alt="PTPN Logo" class="w-full h-full object-contain">
                </div>
                <h1 class="text-2xl font-black text-emerald-700 uppercase tracking-tight">E-Presensi PTPN</h1>
                <p class="text-slate-500 text-xs font-bold uppercase tracking-[0.2em] mt-1">Regional 1</p>
            </div>

            <!-- Heading -->
            <div class="mb-8">
                <h2 class="text-2xl sm:text-3xl font-black text-slate-800 tracking-tight">Selamat Datang! 👋</h2>
                <p class="text-slate-500 text-sm font-medium mt-2">Silakan pilih jenis akun untuk masuk ke sistem.</p>
            </div>

            <!-- Choice Cards -->
            <div class="space-y-4">

                <!-- Card: Peserta Magang -->
                <a href="login.php" class="login-card block bg-white border-2 border-slate-100 rounded-2xl p-5 sm:p-6 text-center no-underline shadow-sm">
                    <div class="icon-wrap bg-emerald-50">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-9 h-9 text-emerald-600" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 14l9-5-9-5-9 5 9 5z" />
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 14l6.16-3.422A12.083 12.083 0 0121 21H3a12.083 12.083 0 012.84-10.422L12 14z" />
                        </svg>
                    </div>
                    <h3 class="text-lg font-black text-slate-800 mb-1">Peserta Magang</h3>
                    <p class="text-slate-500 text-xs font-medium">Absensi, riwayat & laporan kegiatan magang</p>
                    <div class="mt-4 inline-flex items-center gap-2 bg-emerald-600 text-white text-xs font-bold uppercase tracking-widest px-5 py-2.5 rounded-xl shadow-md shadow-emerald-500/30 transition-all hover:bg-emerald-700">
                        Masuk Sebagai Peserta
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M13 7l5 5m0 0l-5 5m5-5H6" />
                        </svg>
                    </div>
                </a>

                <!-- Divider -->
                <div class="divider text-center">
                    <span>atau</span>
                </div>

                <!-- Card: Pembimbing -->
                <a href="login_pembimbing.php" class="login-card block bg-white border-2 border-slate-100 rounded-2xl p-5 sm:p-6 text-center no-underline shadow-sm">
                    <div class="icon-wrap bg-blue-50">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-9 h-9 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                        </svg>
                    </div>
                    <h3 class="text-lg font-black text-slate-800 mb-1">Pembimbing</h3>
                    <p class="text-slate-500 text-xs font-medium">Pantau peserta dan kelola laporan magang</p>
                    <div class="mt-4 inline-flex items-center gap-2 bg-blue-600 text-white text-xs font-bold uppercase tracking-widest px-5 py-2.5 rounded-xl shadow-md shadow-blue-500/30 transition-all hover:bg-blue-700">
                        Masuk Sebagai Pembimbing
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M13 7l5 5m0 0l-5 5m5-5H6" />
                        </svg>
                    </div>
                </a>

            </div>

            <!-- Register link -->
            <div class="text-center mt-8 pt-6 border-t border-slate-100">
                <p class="text-sm text-slate-500 font-medium mb-1">Pendaftar magang baru?</p>
                <a href="register.php" class="text-sm font-bold text-emerald-600 hover:text-emerald-700 hover:underline transition-colors uppercase tracking-wider">
                    Daftar Akun Sekarang →
                </a>
            </div>

        </div>
    </div>

</body>
</html>
