<?php
session_start();
include 'includes/db.php';
if (!isset($_SESSION['login'])) { header("Location: login.php"); exit; }

if (isset($_POST['submit_izin'])) {
    $user_id = $_SESSION['user_id'];
    $status = $_POST['status']; // 'izin' atau 'sakit'
    $keterangan = $_POST['keterangan'];
    $nama_file = "";

    // Logika upload jika statusnya 'sakit'
    if ($status == 'sakit' && isset($_FILES['surat_sakit'])) {
        $nama_file = time() . "_" . $_FILES['surat_sakit']['name'];
        move_uploaded_file($_FILES['surat_sakit']['tmp_name'], 'uploads/surat_sakit/' . $nama_file);
    }

    $query = "INSERT INTO absensi (user_id, status, keterangan, file_surat_sakit, tanggal) 
              VALUES ('$user_id', '$status', '$keterangan', '$nama_file', CURDATE())";
    
    if (mysqli_query($conn, $query)) {
        echo "<script>alert('Data berhasil dikirim!'); window.location='dashboard.php';</script>";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Form Izin / Sakit | PTPN IV</title>
    <link rel="icon" type="image/png" href="assets/img/logo.png">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        body { 
            font-family: 'Plus Jakarta Sans', sans-serif; 
            background-color: #f1f5f9; 
            min-height: 100vh;
        }
        .header-bg { 
            background: linear-gradient(135deg, #064e3b 0%, #10b981 100%); 
        }
        /* Custom scrollbar */
        ::-webkit-scrollbar { width: 6px; }
        ::-webkit-scrollbar-track { background: transparent; }
        ::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
    </style>
</head>
<body class="pb-24 md:pb-8 relative">

    <!-- Header Section -->
    <div class="header-bg pt-8 pb-32 px-4 sm:px-6 lg:px-8 rounded-b-[2.5rem] shadow-lg absolute top-0 w-full z-0 overflow-hidden">
        <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full -translate-y-1/2 translate-x-1/3"></div>
        <div class="absolute bottom-0 left-0 w-40 h-40 bg-white opacity-10 rounded-full translate-y-1/2 -translate-x-1/2"></div>
    </div>

    <!-- Main Content -->
    <div class="max-w-xl mx-auto px-4 sm:px-6 relative z-10 pt-10">
        
        <div class="flex flex-col mb-8 text-white">
            <a href="dashboard.php" class="w-10 h-10 rounded-full border border-emerald-300/30 flex items-center justify-center bg-white/10 hover:bg-white/20 transition-all backdrop-blur-sm mb-4">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
            </a>
            <h1 class="text-3xl font-black tracking-tight mb-1">Pengajuan Izin</h1>
            <p class="text-emerald-100 text-sm font-medium opacity-90">Laporkan ketidakhadiran Anda di sini.</p>
        </div>

        <!-- Form Card -->
        <div class="bg-white rounded-[2rem] p-6 sm:p-8 shadow-[0_20px_40px_-15px_rgba(0,0,0,0.1)] border border-slate-100 relative">
            
            <div class="text-center mb-8">
                <div class="inline-flex p-4 rounded-2xl bg-emerald-50 text-emerald-600 mb-4 border border-emerald-100">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                </div>
                <h2 class="text-xl font-black text-slate-800">Form Ketidakhadiran</h2>
                <p class="text-sm font-medium text-slate-500 mt-1">Silakan isi data dengan benar</p>
            </div>

            <form method="POST" enctype="multipart/form-data" class="space-y-6">
                
                <!-- Status Selection -->
                <div>
                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2 pl-1">Jenis Keperluan</label>
                    <div class="relative">
                        <select id="status" name="status" onchange="toggleUpload()" class="w-full px-4 py-3.5 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all appearance-none cursor-pointer">
                            <option value="izin">Izin (Keperluan Mendesak)</option>
                            <option value="sakit">Sakit (Wajib Surat Dokter)</option>
                        </select>
                        <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-4 text-slate-500">
                            <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/></svg>
                        </div>
                    </div>
                </div>

                <!-- Textarea -->
                <div>
                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2 pl-1">Alasan / Keterangan</label>
                    <textarea name="keterangan" rows="4" class="w-full px-4 py-3 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all resize-none" placeholder="Contoh: Ada urusan keluarga / Demam tinggi..." required></textarea>
                </div>

                <!-- File Upload (Hidden by default) -->
                <div id="upload-section" class="hidden transition-opacity duration-300">
                    <label class="block text-xs font-bold text-rose-500 uppercase tracking-wider mb-2 pl-1">Upload Surat Sakit</label>
                    <div class="relative border-2 border-dashed border-rose-200 bg-rose-50 rounded-2xl p-6 text-center hover:bg-rose-100/50 transition-colors group cursor-pointer">
                        <input type="file" name="surat_sakit" id="file_input" class="absolute inset-0 w-full h-full opacity-0 cursor-pointer z-10" onchange="updateFileName(this)">
                        
                        <div class="flex flex-col items-center justify-center pointer-events-none">
                            <div class="w-12 h-12 bg-rose-100 text-rose-500 rounded-full flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12" />
                                </svg>
                            </div>
                            <p class="font-bold text-slate-700 text-sm" id="file_name">Pilih file atau tarik ke sini</p>
                            <p class="text-[10px] font-bold text-rose-400 mt-2 uppercase tracking-widest">Format: JPG/PNG/PDF (Max 2MB)</p>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="pt-4 border-t border-slate-100">
                    <button type="submit" name="submit_izin" class="w-full bg-emerald-600 hover:bg-emerald-700 text-white font-black uppercase tracking-widest py-4 rounded-xl shadow-[0_10px_20px_-10px_rgba(16,185,129,0.5)] transition-all active:scale-[0.98] flex items-center justify-center gap-2">
                        Kirim Pengajuan
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                            <path d="M10.894 2.553a1 1 0 00-1.788 0l-7 14a1 1 0 001.169 1.409l5-1.429A1 1 0 009 15.571V11a1 1 0 112 0v4.571a1 1 0 00.725.962l5 1.428a1 1 0 001.17-1.408l-7-14z" />
                        </svg>
                    </button>
                </div>
            </form>

        </div>
    </div>

    <!-- Mobile Bottom Navigation -->
    <div class="md:hidden fixed bottom-0 left-0 right-0 bg-white border-t border-slate-200 flex justify-around items-center pt-2 pb-4 px-2 shadow-[0_-10px_40px_rgba(0,0,0,0.08)] z-30">
        <a href="dashboard.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Utama</span>
        </a>
        <a href="riwayat.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Riwayat</span>
        </a>
        <a href="izin.php" class="flex flex-col items-center p-2 text-emerald-600 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" viewBox="0 0 20 20" fill="currentColor">
                <path d="M9 2a1 1 0 000 2h2a1 1 0 100-2H9z" />
                <path fill-rule="evenodd" d="M4 5a2 2 0 012-2 3 3 0 003 3h2a3 3 0 003-3 2 2 0 012 2v11a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm3 4a1 1 0 000 2h.01a1 1 0 100-2H7zm3 0a1 1 0 000 2h3a1 1 0 100-2h-3zm-3 4a1 1 0 100 2h.01a1 1 0 100-2H7zm3 0a1 1 0 100 2h3a1 1 0 100-2h-3z" clip-rule="evenodd" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Izin</span>
        </a>
        <a href="logout.php" class="flex flex-col items-center p-2 text-rose-400 hover:text-rose-600 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Exit</span>
        </a>
    </div>

    <script>
        function toggleUpload() {
            const status = document.getElementById('status').value;
            const section = document.getElementById('upload-section');
            if (status === 'sakit') {
                section.classList.remove('hidden');
                // Small delay to allow display flex to apply before transitioning opacity
                setTimeout(() => {
                    section.classList.add('opacity-100');
                    section.classList.remove('opacity-0', '-translate-y-4');
                }, 10);
            } else {
                section.classList.add('hidden');
            }
        }
        
        function updateFileName(input) {
            const fileNameHtml = document.getElementById('file_name');
            if(input.files && input.files[0]) {
                const name = input.files[0].name;
                fileNameHtml.innerHTML = `<span class="text-emerald-600">${name}</span>`;
            } else {
                fileNameHtml.innerHTML = `Pilih file atau tarik ke sini`;
            }
        }
    </script>
</body>
</html>