<?php
session_start();
include 'includes/db.php';

if (!isset($_SESSION['pembimbing'])) {
    header("Location: login_pembimbing.php");
    exit;
}

// Info pembimbing yang login
$pembimbing_id   = isset($_SESSION['pembimbing_id']) ? (int)$_SESSION['pembimbing_id'] : null;
$pembimbing_nama = isset($_SESSION['pembimbing_nama']) ? $_SESSION['pembimbing_nama'] : 'Pembimbing';

// Filter periode mingguan (Senin–Minggu): pilih satu tanggal dalam minggu
$minggu = isset($_GET['minggu']) ? $_GET['minggu'] : date('Y-m-d');
$ts = strtotime($minggu);
if ($ts === false) {
    $minggu = date('Y-m-d');
    $ts = strtotime($minggu);
}
$tgl_awal = date('Y-m-d', strtotime('monday this week', $ts));
$tgl_akhir = date('Y-m-d', strtotime('sunday this week', $ts));

// Daftar peserta magang: hanya anak bimbingan pembimbing yang login (kecuali akun admin umum)
$where_users = "WHERE role = 'magang'";
if (!empty($pembimbing_id)) {
    $where_users .= " AND pembimbing_id = " . (int)$pembimbing_id;
}

$sql_peserta = "SELECT id, nama, instansi, kategori, jurusan, username, created_at 
    FROM users 
    $where_users 
    ORDER BY id ASC";
$q_peserta = mysqli_query($conn, $sql_peserta);

$list_peserta = [];
while ($p = mysqli_fetch_assoc($q_peserta)) {
    $uid = (int)$p['id'];
    // Hitung per status berdasarkan tanggal absensi (tanggal saat data absensi diinput)
    $q_abs = mysqli_query($conn, "SELECT 
        SUM(CASE WHEN status = 'hadir' THEN 1 ELSE 0 END) as hadir,
        SUM(CASE WHEN status = 'telat' THEN 1 ELSE 0 END) as telat,
        SUM(CASE WHEN status = 'izin' THEN 1 ELSE 0 END) as izin,
        SUM(CASE WHEN status = 'sakit' THEN 1 ELSE 0 END) as sakit
        FROM absensi 
        WHERE user_id = '$uid' 
        AND tanggal BETWEEN '$tgl_awal' AND '$tgl_akhir'");
    $abs = mysqli_fetch_assoc($q_abs);
    $hadir = (int)($abs['hadir'] ?? 0);
    $telat = (int)($abs['telat'] ?? 0);
    $izin = (int)($abs['izin'] ?? 0);
    $sakit = (int)($abs['sakit'] ?? 0);
    $total = $hadir + $telat + $izin + $sakit;
    $persen = $total > 0 ? round((($hadir + $telat) / $total) * 100, 1) : 0;
    // Data peserta dari database (users)
    $list_peserta[] = [
        'id' => $p['id'],
        'nama' => $p['nama'],
        'instansi' => $p['instansi'] !== null && $p['instansi'] !== '' ? $p['instansi'] : '-',
        'kategori' => $p['kategori'],
        'jurusan' => isset($p['jurusan']) && $p['jurusan'] !== null && $p['jurusan'] !== '' ? $p['jurusan'] : '-',
        'hadir' => $hadir,
        'telat' => $telat,
        'izin' => $izin,
        'sakit' => $sakit,
        'total' => $total,
        'persen' => $persen
    ];
}

// Statistik keseluruhan
$total_hadir = array_sum(array_column($list_peserta, 'hadir'));
$total_telat = array_sum(array_column($list_peserta, 'telat'));
$total_izin = array_sum(array_column($list_peserta, 'izin'));
$total_sakit = array_sum(array_column($list_peserta, 'sakit'));
$jumlah_peserta = count($list_peserta);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Laporan Magang | PTPN IV</title>
    <link rel="icon" type="image/png" href="assets/img/logo.png">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        body { 
            font-family: 'Plus Jakarta Sans', sans-serif; 
            background-color: #f1f5f9; 
        }
        /* Custom scrollbar */
        ::-webkit-scrollbar { width: 6px; }
        ::-webkit-scrollbar-track { background: transparent; }
        ::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
        
        .sidebar-bg { background: linear-gradient(180deg, #064e3b 0%, #022c22 100%); }
        
        @media print {
            @page { size: A4 portrait; margin: 1cm; }
            body { background: white !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
            .print-hide { display: none !important; }
            .main-content { width: 100% !important; padding: 0 !important; margin: 0 !important; overflow: visible !important; }
            .print-table { border-collapse: collapse !important; width: 100% !important; }
            .print-table th, .print-table td { border: 1px solid #cbd5e1 !important; color: #000 !important; }
            .print-table th { background-color: #f8fafc !important; }
            .print-text { color: #000 !important; }
            * { text-shadow: none !important; box-shadow: none !important; }
        }
    </style>
</head>
<body class="flex pb-20 md:pb-0 h-screen overflow-hidden print-text">

    <!-- Sidebar Desktop -->
    <aside class="w-64 sidebar-bg text-white hidden md:flex flex-col flex-shrink-0 h-full overflow-y-auto print-hide">
        <div class="p-6 flex items-center gap-4 border-b border-emerald-800/50 mb-6">
            <div class="w-12 h-12 rounded-xl bg-white flex items-center justify-center shadow-sm p-1">
                <img src="assets/img/logo.png" alt="PTPN IV" class="w-full h-full object-contain">
            </div>
            <div>
                <h6 class="font-black tracking-wider text-base mb-0 leading-tight">PTPN IV</h6>
                <p class="text-[10px] text-emerald-300 uppercase tracking-widest font-bold">Pembimbing Panel</p>
            </div>
        </div>
        
        <nav class="flex-1 px-4 space-y-2">
            <a href="dashboard_pembimbing.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-emerald-100/70 hover:bg-white/10 hover:text-white font-bold transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 002-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                </svg>
                Dashboard
            </a>
            <a href="data_magang.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-emerald-100/70 hover:bg-white/10 hover:text-white font-bold transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                </svg>
                Data Magang
            </a>
            <a href="laporan_magang.php" class="flex items-center gap-3 px-4 py-3 rounded-xl bg-white/20 text-white font-bold transition-all border border-white/10">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                </svg>
                Laporan
            </a>
            <a href="ganti_password_pembimbing.php" class="flex items-center gap-3 px-4 py-3 rounded-xl text-emerald-100/70 hover:bg-white/10 hover:text-white font-bold transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 opacity-90" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                </svg>
                Password
            </a>
        </nav>
        
        <div class="p-4 mt-auto">
            <a href="logout_pembimbing.php" class="flex items-center justify-center gap-2 w-full py-3 rounded-xl bg-rose-500/20 text-rose-300 hover:bg-rose-500 hover:text-white font-black uppercase tracking-widest text-xs transition-all border border-rose-500/30">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                </svg>
                Logout
            </a>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="flex-1 flex flex-col h-full overflow-y-auto w-full bg-slate-50 main-content relative">
        
        <!-- Mobile Header (Hidden in Print) -->
        <div class="md:hidden bg-emerald-800 text-white px-4 py-4 flex justify-between items-center shadow-md z-20 print-hide">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-white rounded border border-white/20 flex items-center justify-center p-1 shadow-sm">
                    <img src="assets/img/logo.png" class="w-full h-full object-contain" alt="PTPN IV">
                </div>
                <div>
                    <h1 class="font-black text-sm tracking-widest uppercase">PTPN IV</h1>
                    <p class="text-[9px] text-emerald-200 font-bold uppercase tracking-widest">Pembimbing Panel</p>
                </div>
            </div>
            <a href="logout_pembimbing.php" class="w-8 h-8 flex items-center justify-center bg-rose-500 text-white rounded-lg shadow-sm">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
                </svg>
            </a>
        </div>

        <div class="p-4 md:p-8 flex-1">
            
            <!-- KOP Surat Khusus Print (Hidden on Screen) -->
            <div class="hidden print:block mb-8 border-b-2 border-slate-800 pb-6 print:flex print:items-center print:justify-center print:gap-6">
                <img src="assets/img/logo.png" alt="PTPN IV" class="h-24 object-contain">
                <div class="text-center">
                    <h2 class="text-2xl font-black text-black tracking-widest">PT PERKEBUNAN NUSANTARA IV</h2>
                    <h3 class="text-xl font-bold text-black uppercase tracking-widest mt-1">Regional 1</h3>
                    <p class="text-sm font-medium text-black mt-2">Jl. Sei Batanghari No.2, Medan Sunggal, Kota Medan, Sumatera Utara 20112</p>
                </div>
            </div>

            <!-- Print Title Document -->
            <div class="hidden print:block text-center mb-8 mt-6">
                <h4 class="text-lg font-black uppercase text-black underline underline-offset-4">LAPORAN KEHADIRAN MAGANG MINGGUAN</h4>
            </div>

            <!-- Header Titles (Screen) -->
            <div class="mb-6 print-hide">
                <h2 class="text-2xl md:text-3xl font-black text-slate-800 mb-2">Laporan Magang</h2>
                <p class="text-sm font-medium text-slate-500 mb-1">Rangkuman data absensi peserta magang per periode mingguan.</p>
                <p class="text-xs font-bold text-slate-400 uppercase tracking-wider">Pembimbing: <span class="text-emerald-600"><?= htmlspecialchars($pembimbing_nama) ?></span></p>
            </div>

            <!-- Header Info (Print Only) -->
            <table class="hidden print:table w-full mb-8 text-sm text-black">
                <tr>
                    <td class="w-[15%] font-bold py-1">Pembimbing</td>
                    <td class="w-[2%]">:</td>
                    <td class="w-[33%]"><?= htmlspecialchars($pembimbing_nama) ?></td>
                    <td class="w-[15%] font-bold py-1">Periode</td>
                    <td class="w-[2%]">:</td>
                    <td class="w-[33%]"><?= date('d M Y', strtotime($tgl_awal)) ?> s/d <?= date('d M Y', strtotime($tgl_akhir)) ?></td>
                </tr>
            </table>

            <!-- Filter Card -->
            <div class="bg-white rounded-[1.5rem] p-5 shadow-sm border border-slate-100 mb-6 print-hide">
                <h6 class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-4">Filter Periode & Aksi</h6>
                <form action="" method="GET" class="flex flex-col sm:flex-row items-end gap-4">
                    <div class="w-full sm:w-auto">
                        <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2 pl-1">Pilih Minggu</label>
                        <input type="date" name="minggu" value="<?= $minggu ?>" class="w-full sm:w-48 px-4 py-2.5 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all cursor-pointer">
                    </div>
                    <button type="submit" class="w-full sm:w-auto bg-emerald-600 hover:bg-emerald-700 text-white px-6 py-2.5 rounded-xl font-bold uppercase text-xs tracking-wider transition-colors shadow-sm">
                        Terapkan
                    </button>
                    <div class="w-full sm:flex-1 flex justify-end">
                        <button type="button" onclick="window.print()" class="w-full sm:w-auto bg-slate-800 hover:bg-slate-900 text-white px-6 py-2.5 rounded-xl font-bold uppercase text-xs tracking-wider transition-colors shadow-sm flex items-center justify-center gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2-2v4h10z" />
                            </svg>
                            Cetak Laporan
                        </button>
                    </div>
                </form>
                <p class="text-[11px] font-medium text-slate-500 mt-4 px-1">
                    Merekap data dari <strong><?= date('d M Y', strtotime($tgl_awal)) ?> (Senin)</strong> sampai <strong><?= date('d M Y', strtotime($tgl_akhir)) ?> (Minggu)</strong>.
                </p>
            </div>

            <!-- Callout -->
            <div class="bg-emerald-50 border border-emerald-100 border-l-4 border-l-emerald-500 rounded-lg p-3 mb-6 flex items-start gap-3 print-hide">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-emerald-600 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <p class="text-xs font-semibold text-emerald-800 m-0">
                    Data merekap seluruh status sesuai dengan tanggal absensi diinputkan.
                </p>
            </div>

            <!-- Dashboard Stats Grid -->
            <div class="grid grid-cols-2 lg:grid-cols-4 gap-4 mb-8 print-hide">
                <div class="bg-white p-5 rounded-[1.5rem] border border-slate-100 shadow-sm flex items-center justify-between group">
                    <div>
                        <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Peserta Magang</p>
                        <h3 class="text-2xl font-black text-slate-800"><?= $jumlah_peserta ?></h3>
                    </div>
                    <div class="w-12 h-12 bg-indigo-50 text-indigo-500 rounded-xl flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd" />
                        </svg>
                    </div>
                </div>
                <div class="bg-white p-5 rounded-[1.5rem] border border-slate-100 shadow-sm flex items-center justify-between group">
                    <div>
                        <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Total Hadir</p>
                        <h3 class="text-2xl font-black text-emerald-600"><?= $total_hadir ?></h3>
                    </div>
                    <div class="w-12 h-12 bg-emerald-50 text-emerald-500 rounded-xl flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                    </div>
                </div>
                <!-- Total Telat -->
                <div class="bg-white p-5 rounded-[1.5rem] border border-slate-100 shadow-sm flex items-center justify-between group print-hide">
                    <div>
                        <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Total Telat</p>
                        <h3 class="text-2xl font-black text-indigo-600"><?= $total_telat ?></h3>
                    </div>
                    <div class="w-12 h-12 bg-indigo-50 text-indigo-500 rounded-xl flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />
                        </svg>
                    </div>
                </div>
                <!-- Total Izin -->
                <div class="bg-white p-5 rounded-[1.5rem] border border-slate-100 shadow-sm flex items-center justify-between group">
                    <div>
                        <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Total Izin</p>
                        <h3 class="text-2xl font-black text-amber-500"><?= $total_izin ?></h3>
                    </div>
                    <div class="w-12 h-12 bg-amber-50 text-amber-500 rounded-xl flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                        </svg>
                    </div>
                </div>
                <!-- Total Sakit -->
                <div class="bg-white p-5 rounded-[1.5rem] border border-slate-100 shadow-sm flex items-center justify-between group">
                    <div>
                        <p class="text-[10px] font-bold text-slate-400 uppercase tracking-widest mb-1">Total Sakit</p>
                        <h3 class="text-2xl font-black text-rose-500"><?= $total_sakit ?></h3>
                    </div>
                    <div class="w-12 h-12 bg-rose-50 text-rose-500 rounded-xl flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M3.172 5.172a4 4 0 015.656 0L10 6.343l1.172-1.171a4 4 0 115.656 5.656L10 17.657l-6.828-6.829a4 4 0 010-5.656z" clip-rule="evenodd" />
                        </svg>
                    </div>
                </div>
            </div>

            <!-- Data Table -->
            <div class="bg-white border border-slate-100 shadow-sm rounded-[1.5rem] print:rounded-none print:shadow-none print:border-none overflow-hidden print-table">
                <div class="bg-slate-50 border-b border-slate-100 px-6 py-4 print-hide">
                    <h3 class="font-bold text-slate-700 text-sm uppercase tracking-wider">Rangkuman Abstrak Peserta</h3>
                </div>
                <div class="overflow-x-auto print:overflow-visible">
                    <table class="w-full text-left print-table">
                        <thead class="bg-slate-50 print:bg-slate-100">
                            <tr>
                                <th class="px-6 py-4 text-[10px] print:text-[11px] font-bold text-slate-400 print:text-black uppercase tracking-widest border-b border-slate-100">No</th>
                                <th class="px-6 py-4 text-[10px] print:text-[11px] font-bold text-slate-400 print:text-black uppercase tracking-widest border-b border-slate-100">Nama</th>
                                <th class="px-6 py-4 text-[10px] print:text-[11px] font-bold text-slate-400 print:text-black uppercase tracking-widest border-b border-slate-100">Instansi</th>
                                <th class="px-6 py-4 text-[10px] print:text-[11px] font-bold text-slate-400 print:text-black uppercase tracking-widest border-b border-slate-100">Jurusan</th>
                                <th class="px-6 py-4 text-[10px] print:text-[11px] font-bold text-slate-400 print:text-black uppercase tracking-widest border-b border-slate-100 text-center">Hadir</th>
                                <th class="px-6 py-4 text-[10px] print:text-[11px] font-bold text-slate-400 print:text-black uppercase tracking-widest border-b border-slate-100 text-center">Telat</th>
                                <th class="px-6 py-4 text-[10px] print:text-[11px] font-bold text-slate-400 print:text-black uppercase tracking-widest border-b border-slate-100 text-center">Izin</th>
                                <th class="px-6 py-4 text-[10px] print:text-[11px] font-bold text-slate-400 print:text-black uppercase tracking-widest border-b border-slate-100 text-center">Sakit</th>
                                <th class="px-6 py-4 text-[10px] print:text-[11px] font-bold text-slate-400 print:text-black uppercase tracking-widest border-b border-slate-100">Persentase (%)</th>
                                <th class="px-6 py-4 text-[10px] font-bold text-slate-400 uppercase tracking-widest text-right border-b border-slate-100 print-hide">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-50 print:divide-slate-300 text-sm">
                            <?php if (count($list_peserta) > 0): ?>
                                <?php foreach ($list_peserta as $i => $row): ?>
                                    <tr class="hover:bg-slate-50/50 transition-colors">
                                        <td class="px-6 py-4 font-bold text-slate-400 print:text-black"><?= $i + 1 ?></td>
                                        <td class="px-6 py-4 border-slate-300">
                                            <div class="flex items-center gap-3">
                                                <div class="w-8 h-8 rounded-full bg-emerald-50 text-emerald-600 flex items-center justify-center font-bold print-hide">
                                                    <?= strtoupper(substr($row['nama'], 0, 1)) ?>
                                                </div>
                                                <span class="font-bold text-slate-800 print:text-black"><?= htmlspecialchars($row['nama']) ?></span>
                                            </div>
                                        </td>
                                        <td class="px-6 py-4 text-slate-500 font-medium print:text-black border-slate-300 max-w-[150px] truncate print:whitespace-normal print:overflow-visible"><?= htmlspecialchars($row['instansi']) ?></td>
                                        <td class="px-6 py-4 text-slate-500 font-medium print:text-black py-4 border-slate-300 max-w-[150px] truncate print:whitespace-normal print:overflow-visible"><?= htmlspecialchars($row['jurusan']) ?></td>
                                        
                                        <!-- Real values for print and UI badges for screen -->
                                        <td class="px-6 py-4 text-center border-slate-300">
                                            <span class="inline-flex px-3 py-1 bg-emerald-50 text-emerald-600 print:bg-transparent print:text-black font-black text-xs rounded-lg border border-emerald-100 print:border-none">
                                                <?= $row['hadir'] ?>
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 text-center border-slate-300">
                                            <span class="inline-flex px-3 py-1 bg-indigo-50 text-indigo-600 print:bg-transparent print:text-black font-black text-xs rounded-lg border border-indigo-100 print:border-none">
                                                <?= $row['telat'] ?>
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 text-center border-slate-300">
                                            <span class="inline-flex px-3 py-1 bg-amber-50 text-amber-600 print:bg-transparent print:text-black font-black text-xs rounded-lg border border-amber-100 print:border-none">
                                                <?= $row['izin'] ?>
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 text-center border-slate-300">
                                            <span class="inline-flex px-3 py-1 bg-rose-50 text-rose-600 print:bg-transparent print:text-black font-black text-xs rounded-lg border border-rose-100 print:border-none">
                                                <?= $row['sakit'] ?>
                                            </span>
                                        </td>
                                        
                                        <td class="px-6 py-4 border-slate-300">
                                            <div class="flex items-center gap-3 print:gap-1">
                                                <div class="flex-1 h-2 bg-slate-100 rounded-full overflow-hidden print-hide w-16">
                                                    <div class="h-full bg-emerald-500 rounded-full" style="width: <?= min(100, $row['persen']) ?>%;"></div>
                                                </div>
                                                <span class="font-black text-slate-700 print:text-black text-xs"><?= $row['persen'] ?>%</span>
                                            </div>
                                        </td>

                                        <td class="px-6 py-4 text-right print-hide">
                                            <a href="detail_riwayat.php?id=<?= $row['id'] ?>" class="inline-flex items-center justify-center w-8 h-8 rounded-lg border border-slate-200 text-slate-400 hover:text-emerald-600 hover:border-emerald-300 hover:bg-emerald-50 transition-colors shadow-sm">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                                </svg>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="10" class="text-center py-10 print:py-4 border-slate-300 text-slate-400 print:text-black font-medium text-sm">
                                        <span class="print-hide block mx-auto w-12 h-12 mb-3 bg-slate-100 rounded-full flex items-center justify-center">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 opacity-50 text-slate-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
                                            </svg>
                                        </span>
                                        Belum ada data peserta.
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Signature Area (Print Only) -->
            <div class="hidden print:flex justify-end mt-16 pt-8 pr-12">
                <div class="text-center">
                    <p class="mb-20 text-black">Mengetahui,</p>
                    <p class="font-black text-black underline tracking-wide"><?= htmlspecialchars($pembimbing_nama) ?></p>
                    <p class="text-sm font-medium mt-1 text-black">Pembimbing Magang</p>
                </div>
            </div>

            <div class="h-12 md:h-0 print:hidden"></div>
        </div>
    </main>

    <!-- Mobile Bottom Navigation (Hidden in Print) -->
    <div class="md:hidden fixed bottom-0 left-0 right-0 bg-white border-t border-slate-200 flex justify-around items-center pt-2 pb-safe px-2 shadow-[0_-10px_40px_rgba(0,0,0,0.08)] z-50 print-hide">
        <a href="dashboard_pembimbing.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Utama</span>
        </a>
        <a href="data_magang.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Peserta</span>
        </a>
        <a href="laporan_magang.php" class="flex flex-col items-center p-2 text-emerald-600 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4zm2 6a1 1 0 011-1h6a1 1 0 110 2H7a1 1 0 01-1-1zm1 3a1 1 0 100 2h6a1 1 0 100-2H7z" clip-rule="evenodd" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Laporan</span>
        </a>
        <a href="ganti_password_pembimbing.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Sandi</span>
        </a>
    </div>

</body>
</html>
