<?php
ob_start();
session_start();
include 'includes/db.php';

if (isset($_POST['login'])) {
    $username = trim(mysqli_real_escape_string($conn, $_POST['username']));
    $password = trim($_POST['password']);

    $query = mysqli_query($conn, "SELECT * FROM users WHERE username = '$username'");
    if (mysqli_num_rows($query) === 1) {
        $row = mysqli_fetch_assoc($query);
        
        if ($password === $row['password'] || password_verify($password, $row['password'])) {
            // SIMPAN SESSION DENGAN TELITI
            $_SESSION['login'] = true; // Ini kunci utamanya
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['nama'] = $row['nama'];
            $_SESSION['role'] = strtolower(trim($row['role']));

            header("Location: dashboard.php");
            exit;
        } else { $error = "Password Salah!"; }
    } else { $error = "User tidak ditemukan!"; }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | PTPN IV Regional 1</title>
    <link rel="icon" type="image/png" href="assets/img/logo.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background: linear-gradient(135deg, #064e3b 0%, #10b981 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }
        /* Decorative background elements */
        body::before {
            content: '';
            position: absolute;
            top: -20%;
            left: -10%;
            width: 50%;
            height: 50%;
            background: radial-gradient(circle, rgba(255,255,255,0.15) 0%, transparent 70%);
            border-radius: 50%;
            z-index: 0;
        }
        body::after {
            content: '';
            position: absolute;
            bottom: -20%;
            right: -10%;
            width: 60%;
            height: 60%;
            background: radial-gradient(circle, rgba(0,0,0,0.2) 0%, transparent 70%);
            border-radius: 50%;
            z-index: 0;
        }
        .glass-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.4);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            position: relative;
            z-index: 10;
        }
        .login-sidebar {
            background: url('https://images.unsplash.com/photo-1542601906990-b4d3fb778b09?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80') no-repeat center center;
            background-size: cover;
            position: relative;
        }
        .login-sidebar::after {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(to bottom, rgba(6, 78, 59, 0.4), rgba(6, 78, 59, 0.9));
        }
    </style>
</head>
<body class="p-4 sm:p-8">

    <div class="w-full max-w-5xl mx-auto glass-card rounded-[2rem] sm:rounded-[3rem] overflow-hidden flex flex-col md:flex-row">
        
        <!-- Image Section (Visible on tablet/desktop) -->
        <div class="hidden md:flex md:w-5/12 lg:w-1/2 login-sidebar relative items-center justify-center p-12 text-center text-white">
            <div class="relative z-10">
                <div class="mx-auto w-24 h-24 bg-white rounded-[2rem] p-3 mb-8 shadow-xl border border-white/80 transform rotate-3">
                    <img src="assets/img/logo.png" alt="PTPN Logo" class="w-full h-full object-contain transform -rotate-3">
                </div>
                <h2 class="text-3xl lg:text-4xl font-black mb-3 leading-tight tracking-tight">E-Presensi<br><span class="text-emerald-300">Magang</span></h2>
                <p class="text-emerald-100 font-medium text-sm lg:text-base opacity-90 leading-relaxed max-w-xs mx-auto">Sistem cerdas pemantauan kehadiran dan aktivitas magang PTPN IV Regional 1.</p>
            </div>
            <!-- Decorative dots -->
            <div class="absolute bottom-8 left-8 flex gap-2 z-10">
                <div class="w-2 h-2 rounded-full bg-white opacity-100"></div>
                <div class="w-2 h-2 rounded-full bg-white opacity-40"></div>
                <div class="w-2 h-2 rounded-full bg-white opacity-40"></div>
            </div>
        </div>

        <!-- Form Section -->
        <div class="w-full md:w-7/12 lg:w-1/2 p-8 sm:p-12 lg:p-16 flex flex-col justify-center bg-white/80">
            
            <!-- Mobile Header Logo -->
            <div class="md:hidden text-center mb-8">
                <div class="inline-flex items-center justify-center w-20 h-20 bg-white rounded-[1.5rem] shadow-sm mb-4 p-2 border border-emerald-100">
                    <img src="assets/img/logo.png" alt="PTPN Logo" class="w-full h-full object-contain">
                </div>
                <h3 class="text-2xl font-black text-emerald-700 uppercase tracking-tight">E-Presensi PTPN</h3>
                <p class="text-slate-500 text-xs font-bold uppercase tracking-[0.2em] mt-1">Regional 1</p>
            </div>

            <div class="hidden md:block mb-10">
                <h3 class="text-3xl font-black text-slate-800 tracking-tight">Selamat Datang 👋</h3>
                <p class="text-slate-500 text-sm font-medium mt-2">Silakan masuk menggunakan akun magang Anda.</p>
            </div>

            <?php if(isset($error)): ?>
                <div class="mb-6 p-4 rounded-2xl bg-rose-50 text-rose-600 border border-rose-100 text-xs sm:text-sm font-bold text-center flex items-center justify-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                    </svg>
                    <?= $error ?>
                </div>
            <?php endif; ?>

            <form method="POST" class="space-y-6">
                <div>
                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2">Username</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-slate-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <input type="text" name="username" class="w-full pl-11 pr-4 py-4 md:py-3 lg:py-4 rounded-2xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all text-sm" placeholder="Masukkan username..." required>
                    </div>
                </div>
                
                <div>
                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-2">Password</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-slate-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <input type="password" name="password" class="w-full pl-11 pr-4 py-4 md:py-3 lg:py-4 rounded-2xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all text-sm mb-1" placeholder="••••••••" required>
                    </div>
                </div>

                <div class="pt-2">
                    <button type="submit" name="login" class="w-full bg-emerald-600 text-white py-4 md:py-3 lg:py-4 rounded-2xl font-black uppercase tracking-widest hover:bg-emerald-700 hover:shadow-lg hover:-translate-y-1 transition-all active:scale-95 duration-300 shadow-md shadow-emerald-500/30 flex items-center justify-center gap-2 text-sm sm:text-base">
                        Masuk Dashboard 
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd" />
                        </svg>
                    </button>
                </div>
            </form>

            <div class="text-center mt-10">
                <p class="text-sm text-slate-500 font-medium mb-1">Pendaftar magang baru?</p>
                <a href="register.php" class="text-sm font-bold text-emerald-600 hover:text-emerald-700 hover:underline transition-colors uppercase tracking-wider">Registrasi Akun</a>
            </div>
            
        </div>
    </div>

</body>
</html>