<?php
include 'includes/db.php';

// Ambil daftar pembimbing untuk pilihan di form
$pembimbingResult = mysqli_query($conn, "SELECT id, nama FROM pembimbing ORDER BY nama");
if (!$pembimbingResult) {
    $pembimbingError = "Gagal memuat data pembimbing.";
}

if (isset($_POST['register'])) {
    $nama     = $_POST['nama'];
    $username = $_POST['username'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $instansi = mysqli_real_escape_string($conn, trim($_POST['instansi']));
    $kategori = mysqli_real_escape_string($conn, $_POST['kategori']);
    $jurusan  = isset($_POST['jurusan']) && trim($_POST['jurusan']) !== '' ? mysqli_real_escape_string($conn, trim($_POST['jurusan'])) : '';
    $pembimbing_id = isset($_POST['pembimbing_id']) && $_POST['pembimbing_id'] !== '' 
        ? (int) $_POST['pembimbing_id'] 
        : null;

    // Siapkan nilai pembimbing_id untuk query (NULL jika tidak dipilih)
    $pembimbing_id_value = is_null($pembimbing_id) ? "NULL" : $pembimbing_id;

    $query = "INSERT INTO users (nama, username, password, instansi, kategori, jurusan, pembimbing_id) 
              VALUES ('$nama', '$username', '$password', '$instansi', '$kategori', '$jurusan', $pembimbing_id_value)";
    
    if (mysqli_query($conn, $query)) {
        echo "<script>alert('Registrasi Berhasil! Silakan Login'); window.location='login.php';</script>";
    } else {
        echo 'Error: ' . mysqli_error($conn);
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Magang | PTPN IV Regional 1</title>
    <link rel="icon" type="image/png" href="assets/img/logo.png">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background: linear-gradient(135deg, #064e3b 0%, #10b981 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow-x: hidden;
        }
        /* Decorative background elements */
        body::before {
            content: '';
            position: absolute;
            top: -20%;
            left: -10%;
            width: 50%;
            height: 50%;
            background: radial-gradient(circle, rgba(255,255,255,0.15) 0%, transparent 70%);
            border-radius: 50%;
            z-index: 0;
            pointer-events: none;
        }
        body::after {
            content: '';
            position: absolute;
            bottom: -20%;
            right: -10%;
            width: 60%;
            height: 60%;
            background: radial-gradient(circle, rgba(0,0,0,0.2) 0%, transparent 70%);
            border-radius: 50%;
            z-index: 0;
            pointer-events: none;
        }
        .glass-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.4);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            position: relative;
            z-index: 10;
        }
        .register-sidebar {
            background: url('https://images.unsplash.com/photo-1542601906990-b4d3fb778b09?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80') no-repeat center center;
            background-size: cover;
            position: relative;
        }
        .register-sidebar::after {
            content: '';
            position: absolute;
            inset: 0;
            background: linear-gradient(to bottom, rgba(6, 78, 59, 0.4), rgba(6, 78, 59, 0.9));
        }
        /* Custom scrollbar for the form section */
        .custom-scrollbar::-webkit-scrollbar {
            width: 6px;
        }
        .custom-scrollbar::-webkit-scrollbar-track {
            background: transparent;
        }
        .custom-scrollbar::-webkit-scrollbar-thumb {
            background-color: #cbd5e1;
            border-radius: 20px;
        }
    </style>
</head>
<body class="p-4 sm:p-8 py-10 min-h-screen">

    <div class="w-full max-w-5xl mx-auto glass-card rounded-[2rem] sm:rounded-[3rem] overflow-hidden flex flex-col md:flex-row-reverse shadow-[0_30px_60px_-15px_rgba(0,0,0,0.5)]">
        
        <!-- Image Section (Visible on tablet/desktop) -->
        <div class="hidden md:flex md:w-5/12 lg:w-2/5 register-sidebar relative items-center justify-center p-12 text-center text-white">
            <div class="relative z-10">
                <div class="mx-auto w-20 h-20 bg-white rounded-[1.5rem] p-3 mb-6 shadow-xl border border-white/80 transform rotate-3">
                    <img src="assets/img/logo.png" alt="PTPN Logo" class="w-full h-full object-contain transform -rotate-3">
                </div>
                <h2 class="text-3xl lg:text-4xl font-black mb-3 leading-tight tracking-tight">Mulai<br><span class="text-emerald-300">Magang</span></h2>
                <p class="text-emerald-100 font-medium text-sm border-t border-emerald-500/30 pt-4 mt-4 opacity-90 leading-relaxed max-w-[200px] mx-auto">Bergabunglah dan tingkatkan kompetensi Anda bersama PTPN IV Regional 1.</p>
            </div>
            
            <div class="absolute bottom-6 left-0 right-0 flex justify-center gap-2 z-10">
                <div class="w-2 h-2 rounded-full bg-white opacity-40"></div>
                <div class="w-6 h-2 rounded-full bg-white opacity-100"></div>
            </div>
        </div>

        <!-- Form Section -->
        <div class="w-full md:w-7/12 lg:w-3/5 p-6 sm:p-10 lg:p-12 flex flex-col bg-white/90 relative max-h-[90vh] overflow-y-auto custom-scrollbar">
            
            <!-- Mobile Header Logo -->
            <div class="md:hidden flex items-center gap-4 mb-8 pb-4 border-b border-slate-100">
                <div class="w-14 h-14 bg-white rounded-2xl shadow-sm p-2 border border-emerald-100 flex-shrink-0">
                    <img src="assets/img/logo.png" alt="PTPN Logo" class="w-full h-full object-contain">
                </div>
                <div>
                    <h3 class="text-xl font-black text-emerald-800 tracking-tight">PTPN IV</h3>
                    <p class="text-slate-500 text-[10px] font-bold uppercase tracking-widest">Registrasi Magang</p>
                </div>
            </div>

            <div class="hidden md:block mb-8 pb-6 border-b border-emerald-50">
                <h3 class="text-2xl lg:text-3xl font-black text-slate-800 tracking-tight">Registrasi Akun 📝</h3>
                <p class="text-slate-500 text-sm font-medium mt-1">Lengkapi data diri Anda sesuai dengan surat pengantar.</p>
            </div>

            <form method="POST" class="space-y-5">
                
                <div>
                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-1.5 focus-within:text-emerald-600 transition-colors">Nama Lengkap</label>
                    <input type="text" name="nama" class="w-full px-4 py-3 sm:py-3.5 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all text-sm" placeholder="Contoh: Budi Santoso" required>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 gap-5">
                    <div>
                        <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-1.5 pl-1 focus-within:text-emerald-600 transition-colors">Username</label>
                        <input type="text" name="username" class="w-full px-4 py-3 sm:py-3.5 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all text-sm" placeholder="Untuk login" required>
                    </div>
                    <div>
                        <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-1.5 pl-1 focus-within:text-emerald-600 transition-colors">Password</label>
                        <input type="password" name="password" class="w-full px-4 py-3 sm:py-3.5 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all text-sm" placeholder="••••••••" required>
                    </div>
                </div>

                <div>
                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-1.5 pl-1 focus-within:text-emerald-600 transition-colors">Asal Instansi</label>
                    <input type="text" name="instansi" class="w-full px-4 py-3 sm:py-3.5 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all text-sm" placeholder="Nama Kampus / Sekolah" required>
                </div>

                <div>
                    <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-1.5 pl-1 focus-within:text-emerald-600 transition-colors">Jurusan / Program Studi</label>
                    <input type="text" name="jurusan" class="w-full px-4 py-3 sm:py-3.5 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all text-sm" placeholder="Contoh: Sistem Informasi" required>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 gap-5">
                    <div>
                        <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-1.5 pl-1 focus-within:text-emerald-600 transition-colors">Kategori</label>
                        <div class="relative">
                            <select name="kategori" class="w-full px-4 py-3 sm:py-3.5 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all text-sm appearance-none cursor-pointer">
                                <option value="Universitas">Mahasiswa Universitas</option>
                                <option value="SMK">Siswa SMK</option>
                            </select>
                            <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-4 text-slate-500">
                                <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/></svg>
                            </div>
                        </div>
                    </div>
                    
                    <div>
                        <label class="block text-xs font-bold text-slate-500 uppercase tracking-wider mb-1.5 pl-1 focus-within:text-emerald-600 transition-colors">Pembimbing PTPN</label>
                        <div class="relative">
                            <select name="pembimbing_id" class="w-full px-4 py-3 sm:py-3.5 rounded-xl bg-slate-50 border border-slate-200 outline-none focus:border-emerald-500 focus:bg-white focus:ring-4 focus:ring-emerald-500/10 font-bold text-slate-700 transition-all text-sm appearance-none cursor-pointer" required>
                                <option value="" class="text-slate-400">Pilih Pembimbing</option>
                                <?php if (isset($pembimbingResult) && $pembimbingResult): ?>
                                    <?php while ($p = mysqli_fetch_assoc($pembimbingResult)): ?>
                                        <option value="<?php echo $p['id']; ?>">
                                            <?php echo htmlspecialchars($p['nama']); ?>
                                        </option>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <option value="">Data pembimbing tidak tersedia</option>
                                <?php endif; ?>
                            </select>
                            <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-4 text-slate-500">
                                <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/></svg>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="pt-6">
                    <button type="submit" name="register" class="w-full bg-emerald-600 text-white py-4 md:py-3.5 rounded-xl font-black uppercase tracking-widest hover:bg-emerald-700 hover:shadow-[0_8px_20px_-6px_rgba(16,185,129,0.6)] hover:-translate-y-0.5 transition-all active:scale-[0.98] duration-300 text-sm">
                        Kirim Registrasi ➜
                    </button>
                </div>
            </form>

            <div class="text-center mt-8 pb-4">
                <p class="text-xs sm:text-sm text-slate-500 font-medium mb-1.5">Sudah terdaftar sebelumnya?</p>
                <a href="login.php" class="text-xs sm:text-sm font-bold text-emerald-600 hover:text-emerald-700 hover:underline transition-colors uppercase tracking-widest">Login Disini</a>
            </div>
            
        </div>
    </div>

</body>
</html>