<?php
session_start();
include 'includes/db.php';

if (!isset($_SESSION['login'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$nama_user = $_SESSION['nama'];

// Mengambil data absensi user - Dibatasi 30 data terakhir untuk performa
$query = "SELECT * FROM absensi WHERE user_id = '$user_id' ORDER BY tanggal DESC LIMIT 30";
$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Riwayat Presensi | PTPN IV</title>
    <link rel="icon" type="image/png" href="assets/img/logo.png">
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { 
            font-family: 'Plus Jakarta Sans', sans-serif; 
            background-color: #f1f5f9; 
            background-image: radial-gradient(#e2e8f0 1px, transparent 1px);
            background-size: 20px 20px;
        }
        .header-bg { 
            background: linear-gradient(135deg, #064e3b 0%, #10b981 100%); 
        }
        /* Custom scrollbar */
        ::-webkit-scrollbar { width: 6px; }
        ::-webkit-scrollbar-track { background: transparent; }
        ::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 10px; }
    </style>
</head>
<body class="pb-24 md:pb-8">

    <!-- Header Section -->
    <div class="header-bg pt-8 pb-16 px-4 sm:px-6 lg:px-8 rounded-b-[2.5rem] shadow-lg relative overflow-hidden">
        <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-5 rounded-full -translate-y-1/2 translate-x-1/3"></div>
        <div class="absolute bottom-0 left-0 w-40 h-40 bg-white opacity-10 rounded-full translate-y-1/2 -translate-x-1/2"></div>
        
        <div class="max-w-3xl mx-auto relative z-10 flex justify-between items-center">
            <div>
                <a href="dashboard.php" class="text-emerald-100 hover:text-white flex items-center gap-2 text-sm font-bold tracking-widest uppercase mb-4 transition-colors">
                    <div class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center border border-white/20">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2.5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
                        </svg>
                    </div>
                    Tutup
                </a>
                <h1 class="text-3xl font-black text-white mb-1 tracking-tight">Riwayat Presensi</h1>
                <p class="text-emerald-100 text-sm font-medium opacity-90">Rekap kehadiran dan aktivitas Anda.</p>
            </div>
            
            <div class="hidden md:flex flex-col items-end">
                <span class="block font-bold text-white text-sm"><?= explode(' ', $nama_user)[0] ?></span>
                <span class="text-[10px] text-emerald-200 uppercase tracking-widest font-semibold"><?= $_SESSION['instansi'] ?? 'MAGANG' ?></span>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8 -mt-8 relative z-20">
        
        <?php if (mysqli_num_rows($result) > 0) : ?>
            
            <!-- Timeline container (now just a straight card list) -->
            <div class="flex flex-col gap-4 sm:gap-5 pb-6">
                
                <?php while ($row = mysqli_fetch_assoc($result)) : ?>
                    <!-- Card Item -->
                    <div class="bg-white p-5 sm:p-6 rounded-2xl shadow-sm border border-slate-200 hover:shadow-md hover:-translate-y-0.5 transition-all relative overflow-hidden group">
                        <div class="absolute left-0 top-0 bottom-0 w-[6px] 
                            <?php 
                                if($row['status'] == 'izin') echo 'bg-amber-500';
                                elseif($row['status'] == 'sakit') echo 'bg-rose-500';
                                elseif($row['status'] == 'telat') echo 'bg-indigo-500';
                                else echo 'bg-emerald-500';
                            ?>">
                        </div>
                        
                        <!-- Header: Left (Date+Status), Right (Photo) -->
                        <div class="flex justify-between items-start mb-4 pl-3 sm:pl-4">
                            <div>
                                <h4 class="text-base font-black text-slate-800 tracking-tight"><?= date('l, d M Y', strtotime($row['tanggal'])); ?></h4>
                                <!-- BADGE -->
                                <div class="mt-2 flex flex-wrap gap-2 items-center">
                                    <?php if($row['status'] == 'hadir') : ?>
                                        <span class="px-3 py-1 bg-emerald-50 text-emerald-600 text-[10px] font-black tracking-widest uppercase rounded-lg border border-emerald-100 flex items-center gap-1.5"><span class="w-1.5 h-1.5 rounded-full bg-emerald-500"></span>HADIR</span>
                                    <?php elseif($row['status'] == 'izin') : ?>
                                        <span class="px-3 py-1 bg-amber-50 text-amber-600 text-[10px] font-black tracking-widest uppercase rounded-lg border border-amber-100 flex items-center gap-1.5"><span class="w-1.5 h-1.5 rounded-full bg-amber-500"></span>IZIN</span>
                                    <?php elseif($row['status'] == 'sakit') : ?>
                                        <span class="px-3 py-1 bg-rose-50 text-rose-600 text-[10px] font-black tracking-widest uppercase rounded-lg border border-rose-100 flex items-center gap-1.5"><span class="w-1.5 h-1.5 rounded-full bg-rose-500"></span>SAKIT</span>
                                    <?php elseif($row['status'] == 'telat') : ?>
                                        <span class="px-3 py-1 bg-indigo-50 text-indigo-600 text-[10px] font-black tracking-widest uppercase rounded-lg border border-indigo-100 flex items-center gap-1.5"><span class="w-1.5 h-1.5 rounded-full bg-indigo-500"></span>TELAT</span>
                                    <?php else : ?>
                                        <span class="px-3 py-1 bg-slate-50 text-slate-600 text-[10px] font-black tracking-widest uppercase rounded-lg border border-slate-200">UNKNOWN</span>
                                    <?php endif; ?>
                                    
                                    <?php if(!empty($row['mood_masuk'])): ?>
                                        <span class="px-2.5 py-1 bg-slate-50 text-slate-500 text-[10px] rounded-lg border border-slate-200 font-semibold" title="Mood Masuk"><?= $row['mood_masuk']; ?></span>
                                    <?php endif; ?>
                                    <?php if(!empty($row['mood_pulang'])): ?>
                                        <span class="px-2.5 py-1 bg-slate-50 text-slate-500 text-[10px] rounded-lg border border-slate-200 font-semibold" title="Mood Pulang"><?= $row['mood_pulang']; ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <!-- Photo thumbnail summary -->
                            <?php if (($row['status'] == 'hadir' || $row['status'] == 'telat') && !empty($row['foto_masuk'])) : ?>
                                <a href="uploads/foto_absen/<?= $row['foto_masuk']; ?>" target="_blank" class="block w-12 h-12 sm:w-14 sm:h-14 rounded-2xl overflow-hidden shadow-sm border border-slate-200 hover:ring-2 hover:ring-emerald-200 hover:shadow-md transition-all flex-shrink-0 ml-4">
                                    <img src="uploads/foto_absen/<?= $row['foto_masuk']; ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                                </a>
                            <?php endif; ?>
                        </div>

                        <!-- Time Grid -->
                        <div class="grid grid-cols-2 gap-0 mb-2 pl-3 sm:pl-4 bg-slate-50 border border-slate-100 rounded-xl overflow-hidden mt-4">
                            <div class="flex items-center gap-3 p-3 border-r border-slate-100 bg-white/50">
                                <div class="w-8 h-8 rounded-full bg-white flex items-center justify-center text-slate-400 border border-slate-200 shadow-sm shrink-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1" /></svg>
                                </div>
                                <div class="flex flex-col">
                                    <span class="text-[10px] font-bold text-slate-400 uppercase tracking-widest leading-none mb-1">Masuk</span>
                                    <span class="font-black text-slate-700 text-sm leading-none"><?= $row['jam_masuk'] ? substr($row['jam_masuk'], 0, 5) : '--:--'; ?></span>
                                </div>
                            </div>
                            <div class="flex items-center gap-3 p-3 bg-white/50">
                                <div class="w-8 h-8 rounded-full bg-white flex items-center justify-center text-slate-400 border border-slate-200 shadow-sm shrink-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" /></svg>
                                </div>
                                <div class="flex flex-col">
                                    <span class="text-[10px] font-bold text-slate-400 uppercase tracking-widest leading-none mb-1">Pulang</span>
                                    <span class="font-black text-slate-700 text-sm leading-none"><?= $row['jam_pulang'] ? substr($row['jam_pulang'], 0, 5) : '--:--'; ?></span>
                                </div>
                            </div>
                        </div>

                        <!-- Footer Details -->
                        <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-3 mt-4 pt-4 border-t border-slate-100 pl-3 sm:pl-4">
                            <!-- Notes -->
                            <div class="flex items-start gap-2 text-slate-500">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mt-0.5 flex-shrink-0 text-slate-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <span class="text-xs font-semibold italic text-slate-500">
                                    <?= !empty($row['keterangan']) ? htmlspecialchars($row['keterangan']) : 'Tanpa catatan'; ?>
                                </span>
                            </div>

                            <!-- Maps Link -->
                            <?php if (!empty($row['lokasi_gps'])) : ?>
                                <a href="https://www.google.com/maps?q=<?= htmlspecialchars($row['lokasi_gps']); ?>" target="_blank" class="inline-flex max-w-max items-center justify-center gap-1.5 text-[10px] font-bold text-sky-600 hover:text-white bg-sky-50 hover:bg-sky-500 px-4 py-2 rounded-lg transition-colors border border-sky-100 hover:border-sky-500">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-3.5 w-3.5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                    </svg>
                                    Buka Maps
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

        <?php else : ?>
            
            <div class="bg-white rounded-[2rem] p-12 text-center shadow-sm border border-slate-100 flex flex-col items-center justify-center mt-10">
                <div class="w-24 h-24 bg-slate-50 border border-slate-100 rounded-full flex items-center justify-center text-slate-300 mb-4 shadow-inner">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-slate-300" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                    </svg>
                </div>
                <h3 class="text-lg font-black text-slate-800 mb-1">Riwayat Kosong</h3>
                <p class="text-sm font-medium text-slate-500">Belum ada catatan aktivitas presensi Anda sejauh ini.</p>
            </div>
            
        <?php endif; ?>

    </div>

    <!-- Mobile Bottom Navigation -->
    <div class="md:hidden fixed bottom-0 left-0 right-0 bg-white border-t border-slate-200 flex justify-around items-center pt-2 pb-safe px-2 shadow-[0_-10px_40px_rgba(0,0,0,0.08)] z-30">
        <a href="dashboard.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Utama</span>
        </a>
        <a href="riwayat.php" class="flex flex-col items-center p-2 text-emerald-600 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Riwayat</span>
        </a>
        <a href="izin.php" class="flex flex-col items-center p-2 text-slate-400 hover:text-emerald-500 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Izin</span>
        </a>
        <a href="logout.php" class="flex flex-col items-center p-2 text-rose-400 hover:text-rose-600 transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mb-1" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1" />
            </svg>
            <span class="text-[10px] font-bold uppercase tracking-widest">Exit</span>
        </a>
    </div>

</body>
</html>